/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.CircularBuffer;
import de.huxhorn.sulky.buffers.OverwritingCircularBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingCircularBuffer<E>
implements CircularBuffer<E> {
    private final Logger logger = LoggerFactory.getLogger(BlockingCircularBuffer.class);
    private Lock lock;
    private OverwritingCircularBuffer<E> events;
    private static final int DEFAULT_CONGESTION_DELAY = 500;
    private int congestionDelay;

    public BlockingCircularBuffer(int bufferSize, int congestionDelay) {
        this.events = new OverwritingCircularBuffer(bufferSize);
        this.lock = new ReentrantLock();
        this.congestionDelay = congestionDelay;
    }

    public BlockingCircularBuffer(int bufferSize) {
        this(bufferSize, 500);
    }

    public int getCongestionDelay() {
        return this.congestionDelay;
    }

    public void setCongestionDelay(int congestionDelay) {
        if (congestionDelay < 0) {
            throw new IllegalArgumentException("congestionDelay (" + congestionDelay + ") must not be negative!");
        }
        this.congestionDelay = congestionDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E element) {
        this.lock.lock();
        try {
            while (this.events.isFull()) {
                this.lock.unlock();
                try {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Congestion ({} events) detected, sleeping for {} millis.", (Object)this.events.getAvailableElements(), (Object)this.congestionDelay);
                    }
                    if (this.congestionDelay > 0) {
                        Thread.sleep(this.congestionDelay);
                    }
                }
                catch (InterruptedException e) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Interrupted...");
                    }
                    this.lock.unlock();
                    return;
                }
                this.lock.lock();
            }
            this.events.add(element);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addAll(List<E> elements) {
        for (E element : elements) {
            this.add(element);
        }
    }

    @Override
    public void addAll(E[] elements) {
        for (E element : elements) {
            this.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        this.lock.lock();
        try {
            boolean bl = this.events.isFull();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E removeFirst() {
        this.lock.lock();
        try {
            E e = this.events.removeFirst();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> removeAll() {
        this.lock.lock();
        try {
            if (!this.events.isEmpty()) {
                List<E> list = this.events.removeAll();
                return list;
            }
            List<E> list = null;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.events.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.events.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getRelative(int index) {
        this.lock.lock();
        try {
            E e = this.events.getRelative(index);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E setRelative(int index, E element) {
        this.lock.lock();
        try {
            E e = this.events.setRelative(index, element);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getOverflowCounter() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAvailableElements() {
        this.lock.lock();
        try {
            int n = this.events.getAvailableElements();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getBufferSize() {
        return this.events.getBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(long index) {
        this.lock.lock();
        try {
            E e = this.events.get(index);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.lock.lock();
        try {
            long l = this.events.getSize();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.events.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        this.lock.lock();
        try {
            Iterator<E> iterator = this.events.iterator();
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }
}

