/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import java.text.DecimalFormat;
import org.rrd4j.inspector.ArchiveTableModel;
import org.rrd4j.inspector.DataTableModel;
import org.rrd4j.inspector.DatasourceTableModel;
import org.rrd4j.inspector.HeaderTableModel;
import org.rrd4j.inspector.MainTreeModel;

class InspectorModel {
    private MainTreeModel mainTreeModel = new MainTreeModel();
    private HeaderTableModel generalTableModel = new HeaderTableModel();
    private DatasourceTableModel datasourceTableModel = new DatasourceTableModel();
    private ArchiveTableModel archiveTableModel = new ArchiveTableModel();
    private DataTableModel dataTableModel = new DataTableModel();
    private File file;
    private boolean ok = false;
    private static String DOUBLE_FORMAT = "0.0000000000E00";
    private static final DecimalFormat df = new DecimalFormat(DOUBLE_FORMAT);

    InspectorModel() {
    }

    MainTreeModel getMainTreeModel() {
        return this.mainTreeModel;
    }

    HeaderTableModel getGeneralTableModel() {
        return this.generalTableModel;
    }

    DatasourceTableModel getDatasourceTableModel() {
        return this.datasourceTableModel;
    }

    DataTableModel getDataTableModel() {
        return this.dataTableModel;
    }

    ArchiveTableModel getArchiveTableModel() {
        return this.archiveTableModel;
    }

    void setFile(File file) {
        this.file = file;
        this.ok = this.mainTreeModel.setFile(file);
        this.generalTableModel.setFile(file);
        this.datasourceTableModel.setFile(file);
        this.archiveTableModel.setFile(file);
        this.dataTableModel.setFile(file);
    }

    void refresh() {
        this.setFile(this.file);
    }

    void selectModel(int n, int n2) {
        this.datasourceTableModel.setIndex(n);
        this.archiveTableModel.setIndex(n, n2);
        this.dataTableModel.setIndex(n, n2);
    }

    File getFile() {
        return this.file;
    }

    boolean isOk() {
        return this.ok;
    }

    static String formatDouble(double d, String string) {
        if (Double.isNaN(d)) {
            return string;
        }
        return df.format(d);
    }

    static String formatDouble(double d) {
        return InspectorModel.formatDouble(d, "NaN");
    }
}

