/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

class ValueScaler {
    static final String UNIT_UNKNOWN = "?";
    static final String[] UNIT_SYMBOLS = new String[]{"a", "f", "p", "n", "u", "m", " ", "k", "M", "G", "T", "P", "E"};
    static final int SYMB_CENTER = 6;
    private final double base;
    private double magfact = -1.0;
    private String unit;

    ValueScaler(double d) {
        this.base = d;
    }

    Scaled scale(double d, boolean bl) {
        Scaled scaled;
        if (bl) {
            scaled = this.rescale(d);
        } else if (this.magfact >= 0.0) {
            scaled = new Scaled(d / this.magfact, this.unit);
        } else {
            scaled = this.rescale(d);
            if (scaled.value == 0.0 || Double.isNaN(scaled.value)) {
                this.magfact = -1.0;
            }
        }
        return scaled;
    }

    private Scaled rescale(double d) {
        int n;
        if (d == 0.0 || Double.isNaN(d)) {
            n = 0;
            this.magfact = 1.0;
        } else {
            n = (int)Math.floor(Math.log(Math.abs(d)) / Math.log(this.base));
            this.magfact = Math.pow(this.base, n);
        }
        this.unit = n <= 6 && n >= -6 ? UNIT_SYMBOLS[n + 6] : UNIT_UNKNOWN;
        return new Scaled(d / this.magfact, this.unit);
    }

    static class Scaled {
        double value;
        String unit;

        public Scaled(double d, String string) {
            this.value = d;
            this.unit = string;
        }

        void dump() {
            System.out.println("[" + this.value + this.unit + "]");
        }
    }
}

