/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.rrd4j.graph.GifEncoder;
import org.rrd4j.graph.PathIterator;

class ImageWorker {
    private static final String DUMMY_TEXT = "Dummy";
    static final int IMG_BUFFER_CAPACITY = 10000;
    private BufferedImage img;
    private Graphics2D gd;
    private int imgWidth;
    private int imgHeight;
    private AffineTransform aftInitial;

    ImageWorker(int n, int n2) {
        this.resize(n, n2);
    }

    void resize(int n, int n2) {
        if (this.gd != null) {
            this.dispose();
        }
        this.imgWidth = n;
        this.imgHeight = n2;
        this.img = new BufferedImage(n, n2, 1);
        this.gd = this.img.createGraphics();
        this.aftInitial = this.gd.getTransform();
        this.setAntiAliasing(false);
    }

    void clip(int n, int n2, int n3, int n4) {
        this.gd.setClip(n, n2, n3, n4);
    }

    void transform(int n, int n2, double d) {
        this.gd.translate(n, n2);
        this.gd.rotate(d);
    }

    void reset() {
        this.gd.setTransform(this.aftInitial);
        this.gd.setClip(0, 0, this.imgWidth, this.imgHeight);
    }

    void fillRect(int n, int n2, int n3, int n4, Paint paint) {
        this.gd.setPaint(paint);
        this.gd.fillRect(n, n2, n3, n4);
    }

    void fillPolygon(int[] nArray, int[] nArray2, Paint paint) {
        this.gd.setPaint(paint);
        this.gd.fillPolygon(nArray, nArray2, nArray.length);
    }

    void fillPolygon(double[] dArray, double d, double[] dArray2, Paint paint) {
        this.gd.setPaint(paint);
        PathIterator pathIterator = new PathIterator(dArray2);
        int[] nArray = pathIterator.getNextPath();
        while (nArray != null) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = n2 - n;
            int[] nArray2 = new int[n3 + 2];
            int[] nArray3 = new int[n3 + 2];
            for (int i = n; i < n2; ++i) {
                nArray2[i - n] = (int)dArray[i];
                nArray3[i - n] = (int)dArray2[i];
            }
            nArray2[n3] = nArray2[n3 - 1];
            nArray2[n3 + 1] = nArray2[0];
            int n4 = (int)d;
            nArray3[n3 + 1] = n4;
            nArray3[n3] = n4;
            this.gd.fillPolygon(nArray2, nArray3, nArray2.length);
            this.gd.drawPolygon(nArray2, nArray3, nArray2.length);
            nArray = pathIterator.getNextPath();
        }
    }

    void fillPolygon(double[] dArray, double[] dArray2, double[] dArray3, Paint paint) {
        this.gd.setPaint(paint);
        PathIterator pathIterator = new PathIterator(dArray3);
        int[] nArray = pathIterator.getNextPath();
        while (nArray != null) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = n2 - n;
            int[] nArray2 = new int[n3 * 2];
            int[] nArray3 = new int[n3 * 2];
            for (int i = n; i < n2; ++i) {
                int n4 = i - n;
                int n5 = n3 * 2 - 1 - i + n;
                nArray2[n4] = nArray2[n5] = (int)dArray[i];
                nArray3[n4] = (int)dArray3[i];
                nArray3[n5] = (int)dArray2[i];
            }
            this.gd.fillPolygon(nArray2, nArray3, nArray2.length);
            this.gd.drawPolygon(nArray2, nArray3, nArray2.length);
            nArray = pathIterator.getNextPath();
        }
    }

    void drawLine(int n, int n2, int n3, int n4, Paint paint, Stroke stroke) {
        this.gd.setStroke(stroke);
        this.gd.setPaint(paint);
        this.gd.drawLine(n, n2, n3, n4);
    }

    void drawPolyline(int[] nArray, int[] nArray2, Paint paint, Stroke stroke) {
        this.gd.setStroke(stroke);
        this.gd.setPaint(paint);
        this.gd.drawPolyline(nArray, nArray2, nArray.length);
    }

    void drawPolyline(double[] dArray, double[] dArray2, Paint paint, Stroke stroke) {
        this.gd.setPaint(paint);
        this.gd.setStroke(stroke);
        PathIterator pathIterator = new PathIterator(dArray2);
        int[] nArray = pathIterator.getNextPath();
        while (nArray != null) {
            int n = nArray[0];
            int n2 = nArray[1];
            int[] nArray2 = new int[n2 - n];
            int[] nArray3 = new int[n2 - n];
            for (int i = n; i < n2; ++i) {
                nArray2[i - n] = (int)dArray[i];
                nArray3[i - n] = (int)dArray2[i];
            }
            this.gd.drawPolyline(nArray2, nArray3, nArray2.length);
            nArray = pathIterator.getNextPath();
        }
    }

    void drawString(String string, int n, int n2, Font font, Paint paint) {
        this.gd.setFont(font);
        this.gd.setPaint(paint);
        this.gd.drawString(string, n, n2);
    }

    double getFontAscent(Font font) {
        LineMetrics lineMetrics = font.getLineMetrics(DUMMY_TEXT, this.gd.getFontRenderContext());
        return lineMetrics.getAscent();
    }

    double getFontHeight(Font font) {
        LineMetrics lineMetrics = font.getLineMetrics(DUMMY_TEXT, this.gd.getFontRenderContext());
        return lineMetrics.getAscent() + lineMetrics.getDescent();
    }

    double getStringWidth(String string, Font font) {
        return font.getStringBounds(string, 0, string.length(), this.gd.getFontRenderContext()).getBounds().getWidth();
    }

    void setAntiAliasing(boolean bl) {
        this.gd.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    void dispose() {
        this.gd.dispose();
    }

    void saveImage(OutputStream outputStream, String string, float f) throws IOException {
        if (string.equalsIgnoreCase("png")) {
            ImageIO.write((RenderedImage)this.img, "png", outputStream);
        } else if (string.equalsIgnoreCase("gif")) {
            GifEncoder gifEncoder = new GifEncoder(this.img);
            gifEncoder.encode(outputStream);
        } else if (string.equalsIgnoreCase("jpg") || string.equalsIgnoreCase("jpeg")) {
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(this.img);
            jPEGEncodeParam.setQuality(f, false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(this.img);
        } else {
            throw new IOException("Unsupported image format: " + string);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] saveImage(String string, String string2, float f) throws IOException {
        byte[] byArray = this.getImageBytes(string2, f);
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            filterOutputStream.write(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getImageBytes(String string, float f) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
        try {
            this.saveImage(byteArrayOutputStream, string, f);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    public void loadImage(String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        this.gd.setPaint(texturePaint);
        this.gd.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }
}

