/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.util.Calendar;
import java.util.Date;
import org.rrd4j.core.Util;
import org.rrd4j.data.Plottable;

public class LinearInterpolator
extends Plottable {
    public static final int INTERPOLATE_LEFT = 0;
    public static final int INTERPOLATE_RIGHT = 1;
    public static final int INTERPOLATE_LINEAR = 2;
    public static final int INTERPOLATE_REGRESSION = 3;
    private int lastIndexUsed = 0;
    private int interpolationMethod = 2;
    private long[] timestamps;
    private double[] values;
    double b0 = Double.NaN;
    double b1 = Double.NaN;

    public LinearInterpolator(long[] lArray, double[] dArray) {
        this.timestamps = lArray;
        this.values = dArray;
        this.validate();
    }

    public LinearInterpolator(Date[] dateArray, double[] dArray) {
        this.values = dArray;
        this.timestamps = new long[dateArray.length];
        for (int i = 0; i < dateArray.length; ++i) {
            this.timestamps[i] = Util.getTimestamp(dateArray[i]);
        }
        this.validate();
    }

    public LinearInterpolator(Calendar[] calendarArray, double[] dArray) {
        this.values = dArray;
        this.timestamps = new long[calendarArray.length];
        for (int i = 0; i < calendarArray.length; ++i) {
            this.timestamps[i] = Util.getTimestamp(calendarArray[i]);
        }
        this.validate();
    }

    private void validate() {
        boolean bl = true;
        if (this.timestamps.length != this.values.length || this.timestamps.length < 2) {
            bl = false;
        }
        for (int i = 0; i < this.timestamps.length - 1 && bl; ++i) {
            if (this.timestamps[i] < this.timestamps[i + 1]) continue;
            bl = false;
        }
        if (!bl) {
            throw new IllegalArgumentException("Invalid plottable data supplied");
        }
    }

    public void setInterpolationMethod(int n) {
        switch (n) {
            case 3: {
                this.calculateBestFitLine();
            }
            case 0: 
            case 1: 
            case 2: {
                this.interpolationMethod = n;
                break;
            }
            default: {
                this.interpolationMethod = 2;
            }
        }
    }

    private void calculateBestFitLine() {
        int n = this.timestamps.length;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(this.values[i])) continue;
            d += (double)this.timestamps[i];
            d2 += this.values[i];
            ++n2;
        }
        if (n2 <= 1) {
            this.b1 = Double.NaN;
            this.b0 = Double.NaN;
            return;
        }
        d /= (double)n2;
        d2 /= (double)n2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(this.values[i])) continue;
            double d5 = (double)this.timestamps[i] - d;
            double d6 = this.values[i] - d2;
            d3 += d5 * d6;
            d4 += d5 * d5;
        }
        this.b1 = d3 / d4;
        this.b0 = d2 - this.b1 * d;
    }

    public double getValue(long l) {
        if (this.interpolationMethod == 3) {
            return this.b0 + this.b1 * (double)l;
        }
        int n = this.timestamps.length;
        if (l < this.timestamps[0] || l > this.timestamps[n - 1]) {
            return Double.NaN;
        }
        int n2 = this.lastIndexUsed;
        if (l < this.timestamps[this.lastIndexUsed]) {
            n2 = 0;
        }
        for (int i = n2; i < n; ++i) {
            if (this.timestamps[i] == l) {
                return this.values[i];
            }
            if (i >= n - 1 || this.timestamps[i] >= l || l >= this.timestamps[i + 1]) continue;
            this.lastIndexUsed = i;
            switch (this.interpolationMethod) {
                case 0: {
                    return this.values[i];
                }
                case 1: {
                    return this.values[i + 1];
                }
                case 2: {
                    double d = (this.values[i + 1] - this.values[i]) / (double)(this.timestamps[i + 1] - this.timestamps[i]);
                    return this.values[i] + d * (double)(l - this.timestamps[i]);
                }
            }
            return Double.NaN;
        }
        return Double.NaN;
    }
}

