/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.timespec;

import org.rrd4j.core.Util;
import org.rrd4j.core.timespec.TimeScanner;
import org.rrd4j.core.timespec.TimeSpec;
import org.rrd4j.core.timespec.TimeToken;

public class TimeParser {
    private static final int PREVIOUS_OP = -1;
    TimeToken token;
    TimeScanner scanner;
    TimeSpec spec;
    int op = 21;
    int prev_multiplier = -1;

    public TimeParser(String string) {
        this.scanner = new TimeScanner(string);
        this.spec = new TimeSpec(string);
    }

    private void expectToken(int n, String string) {
        this.token = this.scanner.nextToken();
        if (this.token.id != n) {
            throw new IllegalArgumentException(string);
        }
    }

    private void plusMinus(int n) {
        if (n >= 0) {
            this.op = n;
            this.expectToken(20, "There should be number after " + (this.op == 21 ? (char)'+' : '-'));
            this.prev_multiplier = -1;
        }
        int n2 = Integer.parseInt(this.token.value);
        this.token = this.scanner.nextToken();
        if (this.token.id == 19) {
            switch (this.prev_multiplier) {
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.token = this.scanner.resolveMonthsMinutes(17);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    this.token = this.scanner.resolveMonthsMinutes(13);
                    break;
                }
                default: {
                    this.token = n2 < 6 ? this.scanner.resolveMonthsMinutes(17) : this.scanner.resolveMonthsMinutes(13);
                }
            }
        }
        this.prev_multiplier = this.token.id;
        n2 *= this.op == 21 ? 1 : -1;
        switch (this.token.id) {
            case 18: {
                this.spec.dyear += n2;
                return;
            }
            case 17: {
                this.spec.dmonth += n2;
                return;
            }
            case 16: {
                n2 *= 7;
            }
            case 15: {
                this.spec.dday += n2;
                return;
            }
            case 14: {
                this.spec.dhour += n2;
                return;
            }
            case 13: {
                this.spec.dmin += n2;
                return;
            }
        }
        this.spec.dsec += n2;
    }

    private void timeOfDay() {
        int n = 0;
        this.scanner.saveState();
        if (this.token.value.length() > 2) {
            return;
        }
        int n2 = Integer.parseInt(this.token.value);
        this.token = this.scanner.nextToken();
        if (this.token.id == 25 || this.token.id == 23) {
            this.token = this.scanner.restoreState();
            return;
        }
        if (this.token.id == 24) {
            this.expectToken(20, "Parsing HH:MM syntax, expecting MM as number, got none");
            n = Integer.parseInt(this.token.value);
            if (n > 59) {
                throw new IllegalArgumentException("Parsing HH:MM syntax, got MM = " + n + " (>59!)");
            }
            this.token = this.scanner.nextToken();
        }
        if (this.token.id == 5 || this.token.id == 4) {
            if (n2 > 12) {
                throw new IllegalArgumentException("There cannot be more than 12 AM or PM hours");
            }
            if (this.token.id == 4) {
                if (n2 != 12) {
                    n2 += 12;
                }
            } else if (n2 == 12) {
                n2 = 0;
            }
            this.token = this.scanner.nextToken();
        } else if (n2 > 23) {
            this.token = this.scanner.restoreState();
            return;
        }
        this.spec.hour = n2;
        this.spec.min = n;
        this.spec.sec = 0;
        if (this.spec.hour == 24) {
            this.spec.hour = 0;
            ++this.spec.day;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignDate(long l, long l2, long l3) {
        if (l3 > 138L) {
            if (l3 <= 1970L) throw new IllegalArgumentException("Invalid year " + l3 + " (should be either 00-99 or >1900)");
            l3 -= 1900L;
        } else if (l3 >= 0L && l3 < 38L) {
            l3 += 100L;
        }
        if (l3 < 70L) {
            throw new IllegalArgumentException("Won't handle dates before epoch (01/01/1970), sorry");
        }
        this.spec.year = (int)l3;
        this.spec.month = (int)l2;
        this.spec.day = (int)l;
    }

    private void day() {
        long l = 0L;
        long l2 = this.spec.year;
        switch (this.token.id) {
            case 6: {
                --this.spec.day;
            }
            case 7: {
                this.token = this.scanner.nextToken();
                break;
            }
            case 8: {
                ++this.spec.day;
                this.token = this.scanner.nextToken();
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                long l3 = this.token.id - 28;
                this.expectToken(20, "the day of the month should follow month name");
                l = Long.parseLong(this.token.value);
                this.token = this.scanner.nextToken();
                if (this.token.id == 20) {
                    l2 = Long.parseLong(this.token.value);
                    this.token = this.scanner.nextToken();
                } else {
                    l2 = this.spec.year;
                }
                this.assignDate(l, l3, l2);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                long l4 = this.token.id - 40;
                this.spec.day = (int)((long)this.spec.day + (l4 - (long)this.spec.wday));
                this.token = this.scanner.nextToken();
                break;
            }
            case 20: {
                long l5 = Long.parseLong(this.token.value);
                if (l5 > 315360000L) {
                    this.spec.localtime(l5);
                    this.token = this.scanner.nextToken();
                    break;
                }
                if (l5 > 19700101L && l5 < 24000101L) {
                    l2 = l5 / 10000L;
                    l = l5 % 100L;
                    l5 = l5 / 100L % 100L;
                    this.token = this.scanner.nextToken();
                } else {
                    this.token = this.scanner.nextToken();
                    if (l5 <= 31L && (this.token.id == 25 || this.token.id == 23)) {
                        int n = this.token.id;
                        this.expectToken(20, "there should be " + (n == 23 ? "month" : "day") + " number after " + (n == 23 ? (char)'.' : '/'));
                        l = Long.parseLong(this.token.value);
                        this.token = this.scanner.nextToken();
                        if (this.token.id == n) {
                            this.expectToken(20, "there should be year number after " + (n == 23 ? (char)'.' : '/'));
                            l2 = Long.parseLong(this.token.value);
                            this.token = this.scanner.nextToken();
                        }
                        if (n == 23) {
                            long l6 = l;
                            l = l5;
                            l5 = l6;
                        }
                    }
                }
                if (--l5 < 0L || l5 > 11L) {
                    throw new IllegalArgumentException("Did you really mean month " + (l5 + 1L));
                }
                if (l < 1L || l > 31L) {
                    throw new IllegalArgumentException("I'm afraid that " + l + " is not a valid day of the month");
                }
                this.assignDate(l, l5, l2);
            }
        }
    }

    public TimeSpec parse() {
        long l = Util.getTime();
        int n = 0;
        this.spec.localtime(l);
        this.token = this.scanner.nextToken();
        switch (this.token.id) {
            case 21: 
            case 22: {
                break;
            }
            case 10: {
                this.spec.type = 1;
            }
            case 11: {
                if (this.spec.type != 1) {
                    this.spec.type = 2;
                }
                this.spec.sec = 0;
                this.spec.min = 0;
                this.spec.hour = 0;
                this.spec.day = 0;
                this.spec.month = 0;
                this.spec.year = 0;
            }
            case 9: {
                int n2 = this.token.id;
                this.token = this.scanner.nextToken();
                if (this.token.id == 21 || this.token.id == 22) break;
                if (n2 != 9) {
                    throw new IllegalArgumentException("Words 'start' or 'end' MUST be followed by +|- offset");
                }
                if (this.token.id == -1) break;
                throw new IllegalArgumentException("If 'now' is followed by a token it must be +|- offset");
            }
            case 20: {
                this.timeOfDay();
                if (this.token.id != 20) break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                this.day();
                if (this.token.id != 20) break;
                this.timeOfDay();
                break;
            }
            case 3: {
                n += 4;
            }
            case 2: {
                n += 12;
            }
            case 1: {
                this.spec.hour = n;
                this.spec.min = 0;
                this.spec.sec = 0;
                this.token = this.scanner.nextToken();
                this.day();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unparsable time: " + this.token.value);
            }
        }
        if (this.token.id == 21 || this.token.id == 22) {
            this.scanner.setContext(false);
            while (this.token.id == 21 || this.token.id == 22 || this.token.id == 20) {
                if (this.token.id == 20) {
                    this.plusMinus(-1);
                } else {
                    this.plusMinus(this.token.id);
                }
                this.token = this.scanner.nextToken();
            }
        }
        if (this.token.id != -1) {
            throw new IllegalArgumentException("Unparsable trailing text: " + this.token.value);
        }
        return this.spec;
    }
}

