/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import org.rrd4j.core.jrrd.RRDFile;

public class PDPStatusBlock {
    long offset;
    long size;
    String lastReading;
    int unknownSeconds;
    double value;

    PDPStatusBlock(RRDFile rRDFile) throws IOException {
        this.offset = rRDFile.getFilePointer();
        this.lastReading = rRDFile.readString(30);
        rRDFile.align(4);
        this.unknownSeconds = rRDFile.readInt();
        rRDFile.skipBytes(4);
        this.value = rRDFile.readDouble();
        rRDFile.skipBytes(64);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    public String getLastReading() {
        return this.lastReading;
    }

    public double getValue() {
        return this.value;
    }

    public int getUnknownSeconds() {
        return this.unknownSeconds;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[PDPStatus: OFFSET=0x");
        stringBuilder.append(Long.toHexString(this.offset));
        stringBuilder.append(", SIZE=0x");
        stringBuilder.append(Long.toHexString(this.size));
        stringBuilder.append(", lastReading=");
        stringBuilder.append(this.lastReading);
        stringBuilder.append(", unknownSeconds=");
        stringBuilder.append(this.unknownSeconds);
        stringBuilder.append(", value=");
        stringBuilder.append(this.value);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

