/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Util;

public class Sample {
    private final RrdDb parentDb;
    private long time;
    private final String[] dsNames;
    private final double[] values;
    private final double[] nanValues;

    Sample(RrdDb rrdDb, long l) throws IOException {
        this.parentDb = rrdDb;
        this.time = l;
        this.dsNames = rrdDb.getDsNames();
        this.values = new double[this.dsNames.length];
        this.nanValues = new double[this.dsNames.length];
        Arrays.fill(this.nanValues, Double.NaN);
        this.clearValues();
    }

    private Sample clearValues() {
        System.arraycopy(this.nanValues, 0, this.values, 0, this.values.length);
        return this;
    }

    public Sample setValue(String string, double d) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.dsNames[i].equals(string)) continue;
            this.values[i] = d;
            return this;
        }
        throw new IllegalArgumentException("Datasource " + string + " not found");
    }

    public Sample setValue(int n, double d) {
        if (n < this.values.length) {
            this.values[n] = d;
            return this;
        }
        throw new IllegalArgumentException("Sample datasource index " + n + " out of bounds");
    }

    public Sample setValues(double ... dArray) {
        if (dArray.length <= this.values.length) {
            System.arraycopy(dArray, 0, this.values, 0, dArray.length);
            return this;
        }
        throw new IllegalArgumentException("Invalid number of values specified (found " + dArray.length + ", only " + this.dsNames.length + " allowed)");
    }

    public double[] getValues() {
        return this.values;
    }

    public long getTime() {
        return this.time;
    }

    public Sample setTime(long l) {
        this.time = l;
        return this;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public Sample set(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        int n = stringTokenizer.countTokens();
        if (n > this.values.length + 1) {
            throw new IllegalArgumentException("Invalid number of values specified (found " + this.values.length + ", " + this.dsNames.length + " allowed)");
        }
        String string2 = stringTokenizer.nextToken();
        try {
            this.time = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.equalsIgnoreCase("N") || string2.equalsIgnoreCase("NOW")) {
                this.time = Util.getTime();
            }
            throw new IllegalArgumentException("Invalid sample timestamp: " + string2);
        }
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                this.values[n2] = Double.parseDouble(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        return this;
    }

    public void update() throws IOException {
        this.parentDb.store(this);
        this.clearValues();
    }

    public void setAndUpdate(String string) throws IOException {
        this.set(string);
        this.update();
    }

    public String dump() {
        StringBuilder stringBuilder = new StringBuilder("update \"");
        stringBuilder.append(this.parentDb.getRrdBackend().getPath()).append("\" ").append(this.time);
        for (double d : this.values) {
            stringBuilder.append(":");
            stringBuilder.append(Util.formatDouble(d, "U", false));
        }
        return stringBuilder.toString();
    }

    String getRrdToolCommand() {
        return this.dump();
    }
}

