/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdUpdater;

abstract class RrdPrimitive {
    static final int STRING_LENGTH = 20;
    static final int RRD_INT = 0;
    static final int RRD_LONG = 1;
    static final int RRD_DOUBLE = 2;
    static final int RRD_STRING = 3;
    static final int[] RRD_PRIM_SIZES = new int[]{4, 8, 8, 40};
    private RrdBackend backend;
    private int byteCount;
    private final long pointer;
    private final boolean cachingAllowed;

    RrdPrimitive(RrdUpdater rrdUpdater, int n, boolean bl) throws IOException {
        this(rrdUpdater, n, 1, bl);
    }

    RrdPrimitive(RrdUpdater rrdUpdater, int n, int n2, boolean bl) throws IOException {
        this.backend = rrdUpdater.getRrdBackend();
        this.byteCount = RRD_PRIM_SIZES[n] * n2;
        this.pointer = rrdUpdater.getRrdAllocator().allocate(this.byteCount);
        this.cachingAllowed = bl || this.backend.isCachingAllowed();
    }

    final byte[] readBytes() throws IOException {
        byte[] byArray = new byte[this.byteCount];
        this.backend.read(this.pointer, byArray);
        return byArray;
    }

    final void writeBytes(byte[] byArray) throws IOException {
        assert (byArray.length == this.byteCount) : "Invalid number of bytes supplied to RrdPrimitive.write method";
        this.backend.write(this.pointer, byArray);
    }

    final int readInt() throws IOException {
        return this.backend.readInt(this.pointer);
    }

    final void writeInt(int n) throws IOException {
        this.backend.writeInt(this.pointer, n);
    }

    final long readLong() throws IOException {
        return this.backend.readLong(this.pointer);
    }

    final void writeLong(long l) throws IOException {
        this.backend.writeLong(this.pointer, l);
    }

    final double readDouble() throws IOException {
        return this.backend.readDouble(this.pointer);
    }

    final double readDouble(int n) throws IOException {
        long l = this.pointer + (long)(n * RRD_PRIM_SIZES[2]);
        return this.backend.readDouble(l);
    }

    final double[] readDouble(int n, int n2) throws IOException {
        long l = this.pointer + (long)(n * RRD_PRIM_SIZES[2]);
        return this.backend.readDouble(l, n2);
    }

    final void writeDouble(double d) throws IOException {
        this.backend.writeDouble(this.pointer, d);
    }

    final void writeDouble(int n, double d, int n2) throws IOException {
        long l = this.pointer + (long)(n * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(l, d, n2);
    }

    final void writeDouble(int n, double[] dArray) throws IOException {
        long l = this.pointer + (long)(n * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(l, dArray);
    }

    final String readString() throws IOException {
        return this.backend.readString(this.pointer);
    }

    final void writeString(String string) throws IOException {
        this.backend.writeString(this.pointer, string);
    }

    final boolean isCachingAllowed() {
        return this.cachingAllowed;
    }
}

