/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.rrd4j.core.RrdFileBackend;
import sun.nio.ch.DirectBuffer;

public class RrdNioBackend
extends RrdFileBackend {
    private static final Timer fileSyncTimer = new Timer(true);
    private MappedByteBuffer byteBuffer;
    private TimerTask syncTask = new TimerTask(){

        public void run() {
            RrdNioBackend.this.sync();
        }
    };

    protected RrdNioBackend(String string, boolean bl, int n) throws IOException {
        super(string, bl);
        try {
            this.mapFile();
            if (!bl) {
                fileSyncTimer.schedule(this.syncTask, (long)n * 1000L, (long)n * 1000L);
            }
        }
        catch (IOException iOException) {
            super.close();
            throw iOException;
        }
    }

    private void mapFile() throws IOException {
        long l = this.getLength();
        if (l > 0L) {
            FileChannel.MapMode mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.file.getChannel().map(mapMode, 0L, l);
        }
    }

    private void unmapFile() {
        if (this.byteBuffer != null) {
            if (this.byteBuffer instanceof DirectBuffer) {
                ((DirectBuffer)((Object)this.byteBuffer)).cleaner().clean();
            }
            this.byteBuffer = null;
        }
    }

    protected synchronized void setLength(long l) throws IOException {
        this.unmapFile();
        super.setLength(l);
        this.mapFile();
    }

    protected synchronized void write(long l, byte[] byArray) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Write failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)l);
        this.byteBuffer.put(byArray);
    }

    protected synchronized void read(long l, byte[] byArray) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Read failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)l);
        this.byteBuffer.get(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            if (this.syncTask != null) {
                this.syncTask.cancel();
            }
            this.sync();
            this.unmapFile();
        }
        finally {
            super.close();
        }
    }

    protected synchronized void sync() {
        if (this.byteBuffer != null) {
            this.byteBuffer.force();
        }
    }
}

