/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.RrdMemoryBackendFactory;
import org.rrd4j.core.RrdNioBackendFactory;
import org.rrd4j.core.RrdSafeFileBackendFactory;

public abstract class RrdBackendFactory {
    private static final Map<String, RrdBackendFactory> factories = new ConcurrentHashMap<String, RrdBackendFactory>();
    private static RrdBackendFactory defaultFactory;

    private static void selectDefaultFactory() {
        String string = System.getProperty("java.version");
        if (string == null || string.startsWith("1.3.") || string.startsWith("1.4.0") || string.startsWith("1.4.1")) {
            RrdBackendFactory.setDefaultFactory("FILE");
        } else {
            RrdBackendFactory.setDefaultFactory("NIO");
        }
    }

    public static RrdBackendFactory getFactory(String string) {
        RrdBackendFactory rrdBackendFactory = factories.get(string);
        if (rrdBackendFactory != null) {
            return rrdBackendFactory;
        }
        throw new IllegalArgumentException("No backend factory found with the name specified [" + string + "]");
    }

    public static void registerFactory(RrdBackendFactory rrdBackendFactory) {
        String string = rrdBackendFactory.getFactoryName();
        if (factories.containsKey(string)) {
            throw new IllegalArgumentException("Backend factory '" + string + "' cannot be registered twice");
        }
        factories.put(string, rrdBackendFactory);
    }

    public static void registerAndSetAsDefaultFactory(RrdBackendFactory rrdBackendFactory) {
        RrdBackendFactory.registerFactory(rrdBackendFactory);
        RrdBackendFactory.setDefaultFactory(rrdBackendFactory.getFactoryName());
    }

    public static RrdBackendFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(String string) {
        if (RrdBackend.isInstanceCreated()) {
            throw new IllegalStateException("Could not change the default backend factory. This method must be called before the first RRD gets created");
        }
        defaultFactory = RrdBackendFactory.getFactory(string);
    }

    protected abstract RrdBackend open(String var1, boolean var2) throws IOException;

    protected abstract boolean exists(String var1) throws IOException;

    protected abstract boolean shouldValidateHeader(String var1) throws IOException;

    public abstract String getFactoryName();

    static {
        RrdFileBackendFactory rrdFileBackendFactory = new RrdFileBackendFactory();
        RrdBackendFactory.registerFactory(rrdFileBackendFactory);
        RrdMemoryBackendFactory rrdMemoryBackendFactory = new RrdMemoryBackendFactory();
        RrdBackendFactory.registerFactory(rrdMemoryBackendFactory);
        RrdNioBackendFactory rrdNioBackendFactory = new RrdNioBackendFactory();
        RrdBackendFactory.registerFactory(rrdNioBackendFactory);
        RrdSafeFileBackendFactory rrdSafeFileBackendFactory = new RrdSafeFileBackendFactory();
        RrdBackendFactory.registerFactory(rrdSafeFileBackendFactory);
        RrdBackendFactory.selectDefaultFactory();
    }
}

