/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdDoubleArray;
import org.rrd4j.core.RrdInt;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Util;

public class Robin
implements RrdUpdater {
    private final Archive parentArc;
    private final RrdInt pointer;
    private final RrdDoubleArray values;
    private int rows;

    Robin(Archive archive, int n, boolean bl) throws IOException {
        this.parentArc = archive;
        this.pointer = new RrdInt(this);
        this.values = new RrdDoubleArray(this, n);
        this.rows = n;
        if (bl) {
            this.pointer.set(0);
            this.values.set(0, Double.NaN, n);
        }
    }

    public double[] getValues() throws IOException {
        return this.getValues(0, this.rows);
    }

    void store(double d) throws IOException {
        int n = this.pointer.get();
        this.values.set(n, d);
        this.pointer.set((n + 1) % this.rows);
    }

    void bulkStore(double d, int n) throws IOException {
        assert (n <= this.rows) : "Invalid number of bulk updates: " + n + " rows=" + this.rows;
        int n2 = this.pointer.get();
        int n3 = Math.min(this.rows - n2, n);
        this.values.set(n2, d, n3);
        this.pointer.set((n2 + n3) % this.rows);
        int n4 = n - n3;
        if (n4 > 0) {
            this.values.set(0, d, n4);
            this.pointer.set(n4);
        }
    }

    void update(double[] dArray) throws IOException {
        assert (this.rows == dArray.length) : "Invalid number of robin values supplied (" + dArray.length + "), exactly " + this.rows + " needed";
        this.pointer.set(0);
        this.values.writeDouble(0, dArray);
    }

    public void setValues(double ... dArray) throws IOException {
        if (this.rows != dArray.length) {
            throw new IllegalArgumentException("Invalid number of robin values supplied (" + dArray.length + "), exactly " + this.rows + " needed");
        }
        this.update(dArray);
    }

    public void setValues(double d) throws IOException {
        double[] dArray = new double[this.rows];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
        }
        this.update(dArray);
    }

    String dump() throws IOException {
        double[] dArray;
        StringBuilder stringBuilder = new StringBuilder("Robin " + this.pointer.get() + "/" + this.rows + ": ");
        for (double d : dArray = this.getValues()) {
            stringBuilder.append(Util.formatDouble(d, true)).append(" ");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public double getValue(int n) throws IOException {
        int n2 = (this.pointer.get() + n) % this.rows;
        return this.values.get(n2);
    }

    public void setValue(int n, double d) throws IOException {
        int n2 = (this.pointer.get() + n) % this.rows;
        this.values.set(n2, d);
    }

    double[] getValues(int n, int n2) throws IOException {
        assert (n2 <= this.rows) : "Too many values requested: " + n2 + " rows=" + this.rows;
        int n3 = (this.pointer.get() + n) % this.rows;
        int n4 = Math.min(this.rows - n3, n2);
        double[] dArray = this.values.get(n3, n4);
        if (n4 < n2) {
            int n5 = n2 - n4;
            double[] dArray2 = this.values.get(0, n5);
            double[] dArray3 = new double[n2];
            int n6 = 0;
            for (double d : dArray) {
                dArray3[n6++] = d;
            }
            for (double d : dArray2) {
                dArray3[n6++] = d;
            }
            return dArray3;
        }
        return dArray;
    }

    public Archive getParent() {
        return this.parentArc;
    }

    public int getSize() {
        return this.rows;
    }

    public void copyStateTo(RrdUpdater rrdUpdater) throws IOException {
        if (!(rrdUpdater instanceof Robin)) {
            throw new IllegalArgumentException("Cannot copy Robin object to " + rrdUpdater.getClass().getName());
        }
        Robin robin = (Robin)rrdUpdater;
        int n = this.rows - robin.rows;
        if (n == 0) {
            robin.pointer.set(this.pointer.get());
            robin.values.writeBytes(this.values.readBytes());
        } else {
            for (int i = 0; i < robin.rows; ++i) {
                int n2 = i + n;
                robin.store(n2 >= 0 ? this.getValue(n2) : Double.NaN);
            }
        }
    }

    public void filterValues(double d, double d2) throws IOException {
        for (int i = 0; i < this.rows; ++i) {
            double d3 = this.values.get(i);
            if (!Double.isNaN(d) && !Double.isNaN(d3) && d > d3) {
                this.values.set(i, Double.NaN);
            }
            if (Double.isNaN(d2) || Double.isNaN(d3) || !(d2 < d3)) continue;
            this.values.set(i, Double.NaN);
        }
    }

    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }
}

