/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdInt;
import org.rrd4j.core.RrdLong;
import org.rrd4j.core.RrdString;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlWriter;

public class Header
implements RrdUpdater {
    static final int SIGNATURE_LENGTH = 5;
    static final String SIGNATURE = "RRD4J";
    static final String DEFAULT_SIGNATURE = "RRD4J, version 0.1";
    static final String RRDTOOL_VERSION = "0001";
    private RrdDb parentDb;
    private RrdString signature;
    private RrdLong step;
    private RrdInt dsCount;
    private RrdInt arcCount;
    private RrdLong lastUpdateTime;

    Header(RrdDb rrdDb, RrdDef rrdDef) throws IOException {
        this(rrdDb, rrdDef, DEFAULT_SIGNATURE);
    }

    Header(RrdDb rrdDb, RrdDef rrdDef, String string) throws IOException {
        this.parentDb = rrdDb;
        this.signature = new RrdString(this);
        this.step = new RrdLong(this, true);
        this.dsCount = new RrdInt(this, true);
        this.arcCount = new RrdInt(this, true);
        this.lastUpdateTime = new RrdLong(this);
        if (rrdDef != null) {
            this.signature.set(string);
            this.step.set(rrdDef.getStep());
            this.dsCount.set(rrdDef.getDsCount());
            this.arcCount.set(rrdDef.getArcCount());
            this.lastUpdateTime.set(rrdDef.getStartTime());
        }
    }

    Header(RrdDb rrdDb, DataImporter dataImporter) throws IOException {
        this(rrdDb, (RrdDef)null);
        String string = dataImporter.getVersion();
        if (!RRDTOOL_VERSION.equals(string)) {
            throw new IllegalArgumentException("Could not unserialize xml version " + string);
        }
        this.signature.set(DEFAULT_SIGNATURE);
        this.step.set(dataImporter.getStep());
        this.dsCount.set(dataImporter.getDsCount());
        this.arcCount.set(dataImporter.getArcCount());
        this.lastUpdateTime.set(dataImporter.getLastUpdateTime());
    }

    public String getSignature() throws IOException {
        return this.signature.get();
    }

    public String getInfo() throws IOException {
        return this.getSignature().substring(5);
    }

    public void setInfo(String string) throws IOException {
        if (string != null && string.length() > 0) {
            this.signature.set(SIGNATURE + string);
        } else {
            this.signature.set(SIGNATURE);
        }
    }

    public long getLastUpdateTime() throws IOException {
        return this.lastUpdateTime.get();
    }

    public long getStep() throws IOException {
        return this.step.get();
    }

    public int getDsCount() throws IOException {
        return this.dsCount.get();
    }

    public int getArcCount() throws IOException {
        return this.arcCount.get();
    }

    void setLastUpdateTime(long l) throws IOException {
        this.lastUpdateTime.set(l);
    }

    String dump() throws IOException {
        return "== HEADER ==\nsignature:" + this.getSignature() + " lastUpdateTime:" + this.getLastUpdateTime() + " step:" + this.getStep() + " dsCount:" + this.getDsCount() + " arcCount:" + this.getArcCount() + "\n";
    }

    void appendXml(XmlWriter xmlWriter) throws IOException {
        xmlWriter.writeComment(this.signature.get());
        xmlWriter.writeTag("version", RRDTOOL_VERSION);
        xmlWriter.writeComment("Seconds");
        xmlWriter.writeTag("step", this.step.get());
        xmlWriter.writeComment(Util.getDate(this.lastUpdateTime.get()));
        xmlWriter.writeTag("lastupdate", this.lastUpdateTime.get());
    }

    public void copyStateTo(RrdUpdater rrdUpdater) throws IOException {
        if (!(rrdUpdater instanceof Header)) {
            throw new IllegalArgumentException("Cannot copy Header object to " + rrdUpdater.getClass().getName());
        }
        Header header = (Header)rrdUpdater;
        header.signature.set(this.signature.get());
        header.lastUpdateTime.set(this.lastUpdateTime.get());
    }

    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    boolean isRrd4jHeader() throws IOException {
        return this.signature.get().startsWith(SIGNATURE) || this.signature.get().startsWith("JR");
    }

    void validateHeader() throws IOException {
        if (!this.isRrd4jHeader()) {
            throw new IOException("Invalid file header. File [" + this.parentDb.getCanonicalPath() + "] is not a RRD4J RRD file");
        }
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }
}

