/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import org.rrd4j.ConsolFun;

public class ArcDef {
    private ConsolFun consolFun;
    private double xff;
    private int steps;
    private int rows;

    public ArcDef(ConsolFun consolFun, double d, int n, int n2) {
        if (consolFun == null) {
            throw new IllegalArgumentException("Null consolidation function specified");
        }
        if (Double.isNaN(d) || d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid xff, must be >= 0 and < 1: " + d);
        }
        if (n < 1 || n2 < 2) {
            throw new IllegalArgumentException("Invalid steps/rows settings: " + n + "/" + n2 + ". Minimal values allowed are steps=1, rows=2");
        }
        this.consolFun = consolFun;
        this.xff = d;
        this.steps = n;
        this.rows = n2;
    }

    public ConsolFun getConsolFun() {
        return this.consolFun;
    }

    public double getXff() {
        return this.xff;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getRows() {
        return this.rows;
    }

    public String dump() {
        return "RRA:" + (Object)((Object)this.consolFun) + ":" + this.xff + ":" + this.steps + ":" + this.rows;
    }

    public boolean equals(Object object) {
        if (object instanceof ArcDef) {
            ArcDef arcDef = (ArcDef)object;
            return this.consolFun == arcDef.consolFun && this.steps == arcDef.steps;
        }
        return false;
    }

    void setRows(int n) {
        this.rows = n;
    }

    boolean exactlyEqual(ArcDef arcDef) {
        return this.consolFun == arcDef.consolFun && this.xff == arcDef.xff && this.steps == arcDef.steps && this.rows == arcDef.rows;
    }
}

