/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.DsType;
import org.rrd4j.cmd.ColonSplitter;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Util;

class RrdTuneCmd
extends RrdToolCmd {
    RrdTuneCmd() {
    }

    String getCmdType() {
        return "tune";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object execute() throws IOException {
        String[] stringArray = this.getMultipleOptionValues("h", "heartbeat");
        String[] stringArray2 = this.getMultipleOptionValues("i", "minimum");
        String[] stringArray3 = this.getMultipleOptionValues("a", "maximum");
        String[] stringArray4 = this.getMultipleOptionValues("d", "data-source-type");
        String[] stringArray5 = this.getMultipleOptionValues("r", "data-source-rename");
        String[] stringArray6 = this.getRemainingWords();
        if (stringArray6.length < 2) {
            throw new IllegalArgumentException("File name not specified");
        }
        if (stringArray6.length > 2) {
            throw new IllegalArgumentException("Unexpected token encountered: " + stringArray6[2]);
        }
        String string = stringArray6[1];
        RrdDb rrdDb = RrdTuneCmd.getRrdDbReference(string);
        try {
            for (String string2 : stringArray) {
                this.tuneHeartbeat(rrdDb, string2);
            }
            for (String string2 : stringArray2) {
                this.tuneMinimum(rrdDb, string2);
            }
            for (String string2 : stringArray3) {
                this.tuneMaximum(rrdDb, string2);
            }
            for (String string2 : stringArray5) {
                this.tuneName(rrdDb, string2);
            }
            for (String string2 : stringArray4) {
                this.tuneType(rrdDb, string2);
            }
            if (stringArray.length == 0 && stringArray2.length == 0 && stringArray3.length == 0 && stringArray4.length == 0 && stringArray5.length == 0) {
                this.dump(rrdDb);
            }
        }
        finally {
            RrdTuneCmd.releaseRrdDbReference(rrdDb);
        }
        return string;
    }

    private void tuneHeartbeat(RrdDb rrdDb, String string) throws IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        long l = Long.parseLong(stringArray[1]);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setHeartbeat(l);
    }

    private void tuneMinimum(RrdDb rrdDb, String string) throws IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        double d = Util.parseDouble(stringArray[1]);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setMinValue(d, false);
    }

    private void tuneMaximum(RrdDb rrdDb, String string) throws IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        double d = Util.parseDouble(stringArray[1]);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setMaxValue(d, false);
    }

    private void tuneName(RrdDb rrdDb, String string) throws IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setDsName(string3);
    }

    private void tuneType(RrdDb rrdDb, String string) throws IOException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid suntax in: " + string);
        }
        String string2 = stringArray[0];
        DsType dsType = DsType.valueOf(stringArray[1]);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setDsType(dsType);
    }

    private void dump(RrdDb rrdDb) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = rrdDb.getDsCount();
        for (int i = 0; i < n; ++i) {
            Datasource datasource = rrdDb.getDatasource(i);
            stringBuilder.append("DS[");
            stringBuilder.append(datasource.getDsName());
            stringBuilder.append("] typ: ");
            stringBuilder.append((Object)datasource.getDsType());
            while (stringBuilder.length() < 24) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("hbt: ");
            stringBuilder.append(datasource.getHeartbeat());
            while (stringBuilder.length() < 40) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("min: ");
            stringBuilder.append(String.format("%-11f", datasource.getMinValue()));
            stringBuilder.append("max: ");
            stringBuilder.append(String.format("%-11f", datasource.getMaxValue()));
            RrdTuneCmd.println(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }
}

