/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdUpdater;

class RrdInfoCmd
extends RrdToolCmd {
    RrdInfoCmd() {
    }

    String getCmdType() {
        return "info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object execute() throws IOException {
        String string;
        String[] stringArray = this.getRemainingWords();
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid rrdinfo syntax");
        }
        String string2 = stringArray[1];
        RrdDb rrdDb = RrdInfoCmd.getRrdDbReference(string2);
        try {
            string = this.getInfo(rrdDb);
            RrdInfoCmd.println(string);
        }
        finally {
            RrdInfoCmd.releaseRrdDbReference(rrdDb);
        }
        return string;
    }

    private String getInfo(RrdDb rrdDb) throws IOException {
        RrdUpdater rrdUpdater;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("filename = \"").append(rrdDb.getPath()).append("\"\n");
        stringBuilder.append("rrd_version = \"0001\"\n");
        stringBuilder.append("step = ").append(rrdDb.getHeader().getStep()).append("\n");
        stringBuilder.append("last_update = ").append(rrdDb.getHeader().getLastUpdateTime()).append("\n");
        for (n = 0; n < rrdDb.getDsCount(); ++n) {
            rrdUpdater = rrdDb.getDatasource(n);
            stringBuilder.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].type = \"").append((Object)((Datasource)rrdUpdater).getDsType()).append("\"\n");
            stringBuilder.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].minimal_heartbeat = ").append(((Datasource)rrdUpdater).getHeartbeat()).append("\n");
            stringBuilder.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].min = ").append(((Datasource)rrdUpdater).getMinValue()).append("\n");
            stringBuilder.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].max = ").append(((Datasource)rrdUpdater).getMaxValue()).append("\n");
            stringBuilder.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].last_ds = ").append(((Datasource)rrdUpdater).getLastValue()).append("\n");
            stringBuilder.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].value = ").append(((Datasource)rrdUpdater).getAccumValue()).append("\n");
            stringBuilder.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].unknown_sec = ").append(((Datasource)rrdUpdater).getNanSeconds()).append("\n");
        }
        for (n = 0; n < rrdDb.getArcCount(); ++n) {
            rrdUpdater = rrdDb.getArchive(n);
            stringBuilder.append("rra[").append(n).append("].cf = \"").append((Object)((Archive)rrdUpdater).getConsolFun()).append("\"\n");
            stringBuilder.append("rra[").append(n).append("].rows = ").append(((Archive)rrdUpdater).getRows()).append("\n");
            stringBuilder.append("rra[").append(n).append("].pdp_per_row = ").append(((Archive)rrdUpdater).getSteps()).append("\n");
            stringBuilder.append("rra[").append(n).append("].xff = ").append(((Archive)rrdUpdater).getXff()).append("\n");
            for (int i = 0; i < rrdDb.getDsCount(); ++i) {
                stringBuilder.append("rra[").append(n).append("].cdp_prep[").append(i).append("].value = ").append(((Archive)rrdUpdater).getArcState(i).getAccumValue()).append("\n");
                stringBuilder.append("rra[").append(n).append("].cdp_prep[").append(i).append("].unknown_datapoints = ").append(((Archive)rrdUpdater).getArcState(i).getNanSteps()).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

