/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.cmd.ColonSplitter;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Util;

class RrdCreateCmd
extends RrdToolCmd {
    static final String DEFAULT_START = "now-10s";
    static final String DEFAULT_STEP = "300";
    private RrdDef rrdDef;

    RrdCreateCmd() {
    }

    String getCmdType() {
        return "create";
    }

    Object execute() throws IOException {
        String string = this.getOptionValue("b", "start", DEFAULT_START);
        long l = Util.getTimestamp(string);
        String string2 = this.getOptionValue("s", "step", DEFAULT_STEP);
        long l2 = RrdCreateCmd.parseLong(string2);
        String[] stringArray = this.getRemainingWords();
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("RRD file path not specified");
        }
        String string3 = stringArray[1];
        this.rrdDef = new RrdDef(string3, l, l2);
        for (int i = 2; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("DS:")) {
                this.parseDef(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("RRA:")) {
                this.parseRra(stringArray[i]);
                continue;
            }
            throw new IllegalArgumentException("Invalid rrdcreate syntax: " + stringArray[i]);
        }
        return this.createRrdDb();
    }

    private void parseDef(String string) {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length < 6) {
            throw new IllegalArgumentException("Invalid DS definition: " + string);
        }
        String string2 = stringArray[1];
        DsType dsType = DsType.valueOf(stringArray[2]);
        long l = RrdCreateCmd.parseLong(stringArray[3]);
        double d = RrdCreateCmd.parseDouble(stringArray[4]);
        double d2 = RrdCreateCmd.parseDouble(stringArray[5]);
        this.rrdDef.addDatasource(string2, dsType, l, d, d2);
    }

    private void parseRra(String string) {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length < 5) {
            throw new IllegalArgumentException("Invalid RRA definition: " + string);
        }
        ConsolFun consolFun = ConsolFun.valueOf(stringArray[1]);
        double d = RrdCreateCmd.parseDouble(stringArray[2]);
        int n = RrdCreateCmd.parseInt(stringArray[3]);
        int n2 = RrdCreateCmd.parseInt(stringArray[4]);
        this.rrdDef.addArchive(consolFun, d, n, n2);
    }

    private String createRrdDb() throws IOException {
        RrdDb rrdDb = RrdCreateCmd.getRrdDbReference(this.rrdDef);
        RrdCreateCmd.releaseRrdDbReference(rrdDb);
        return this.rrdDef.getPath();
    }
}

