/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec;

import de.huxhorn.sulky.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableEncoder<E extends Serializable>
implements Encoder<E> {
    private boolean compressing;

    public SerializableEncoder() {
        this(false);
    }

    public SerializableEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(E object) {
        Object gos;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            if (this.compressing) {
                gos = new GZIPOutputStream(bos);
                oos = new ObjectOutputStream((OutputStream)gos);
            } else {
                oos = new ObjectOutputStream(bos);
            }
            oos.writeObject(object);
            oos.flush();
            oos.close();
            gos = bos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray;
            try {
                e.printStackTrace();
                byArray = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                IOUtils.closeQuietly((OutputStream)bos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)oos);
            IOUtils.closeQuietly((OutputStream)bos);
            return byArray;
        }
        IOUtils.closeQuietly((OutputStream)oos);
        IOUtils.closeQuietly((OutputStream)bos);
        return gos;
    }

    public String toString() {
        return "SerializableEncoder[compressing=" + this.compressing + "]";
    }
}

