/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Util;
import org.rrd4j.core.jrrd.RRDatabase;

class RrdToolReader
extends DataImporter {
    private RRDatabase rrd;

    RrdToolReader(String string) throws IOException {
        this.rrd = new RRDatabase(string);
    }

    String getVersion() {
        return this.rrd.getHeader().getVersion();
    }

    long getLastUpdateTime() {
        return Util.getTimestamp(this.rrd.getLastUpdate());
    }

    long getStep() {
        return this.rrd.getHeader().getPDPStep();
    }

    int getDsCount() {
        return this.rrd.getHeader().getDSCount();
    }

    int getArcCount() throws IOException {
        return this.rrd.getNumArchives();
    }

    String getDsName(int n) {
        return this.rrd.getDataSource(n).getName();
    }

    String getDsType(int n) {
        return this.rrd.getDataSource(n).getType().toString();
    }

    long getHeartbeat(int n) {
        return this.rrd.getDataSource(n).getMinimumHeartbeat();
    }

    double getMinValue(int n) {
        return this.rrd.getDataSource(n).getMinimum();
    }

    double getMaxValue(int n) {
        return this.rrd.getDataSource(n).getMaximum();
    }

    double getLastValue(int n) {
        String string = this.rrd.getDataSource(n).getPDPStatusBlock().getLastReading();
        return Util.parseDouble(string);
    }

    double getAccumValue(int n) {
        return this.rrd.getDataSource(n).getPDPStatusBlock().getValue();
    }

    long getNanSeconds(int n) {
        return this.rrd.getDataSource(n).getPDPStatusBlock().getUnknownSeconds();
    }

    ConsolFun getConsolFun(int n) {
        return ConsolFun.valueOf(this.rrd.getArchive(n).getType().toString());
    }

    double getXff(int n) {
        return this.rrd.getArchive(n).getXff();
    }

    int getSteps(int n) {
        return this.rrd.getArchive(n).getPdpCount();
    }

    int getRows(int n) throws IOException {
        return this.rrd.getArchive(n).getRowCount();
    }

    double getStateAccumValue(int n, int n2) throws IOException {
        return this.rrd.getArchive(n).getCDPStatusBlock(n2).getValue();
    }

    int getStateNanSteps(int n, int n2) throws IOException {
        return this.rrd.getArchive(n).getCDPStatusBlock(n2).getUnknownDatapoints();
    }

    double[] getValues(int n, int n2) throws IOException {
        return this.rrd.getArchive(n).getValues()[n2];
    }

    void release() throws IOException {
        if (this.rrd != null) {
            this.rrd.close();
            this.rrd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }
}

