/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.tooltips;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.table.TooltipGenerator;
import de.huxhorn.sulky.formatting.SimpleXml;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.JTable;

public class MessageTooltipGenerator
implements TooltipGenerator {
    public String createTooltipText(JTable table, int row) {
        LoggingEvent event;
        String text;
        EventWrapper wrapper;
        Serializable eventObj;
        int MAX_LINE_LENGTH = 80;
        int MAX_LINES = 20;
        String tooltip = null;
        Object value = table.getValueAt(row, 0);
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof LoggingEvent && (text = (event = (LoggingEvent)eventObj).getMessage()) != null) {
            StringTokenizer tok = new StringTokenizer(text, "\n", false);
            StringBuilder string = new StringBuilder();
            int lineCounter = 0;
            while (tok.hasMoreTokens()) {
                String line = tok.nextToken();
                if ((line = line.trim()).length() <= 0) continue;
                line = line.replace('\t', ' ');
                if (lineCounter < 20) {
                    if (lineCounter > 0) {
                        string.append("\n");
                    }
                    if (line.length() > 80) {
                        string.append(line.substring(0, 76));
                        string.append("[..]");
                    } else {
                        string.append(line);
                    }
                }
                ++lineCounter;
            }
            if (lineCounter >= 20) {
                int remaining = lineCounter - 20 + 1;
                string.append("\n[.. ").append(remaining).append(" more lines ..]");
            }
            tooltip = SimpleXml.escape((String)string.toString());
            tooltip = tooltip.replace("\n", "<br>");
            tooltip = "<html><tt><pre>" + tooltip + "</pre></tt></html>";
        }
        return tooltip;
    }
}

