/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.table.Colors;
import de.huxhorn.lilith.swing.table.ColorsProvider;
import de.huxhorn.lilith.swing.table.TooltipGenerator;
import de.huxhorn.lilith.swing.table.model.EventWrapperTableModel;
import de.huxhorn.lilith.swing.table.model.PersistentTableColumnModel;
import de.huxhorn.sulky.conditions.Condition;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventWrapperViewTable<T extends Serializable>
extends JTable
implements ColorsProvider {
    public static final String SCROLLING_TO_BOTTOM_PROPERTY = "scrollingToBottom";
    public static final String FILTER_CONDITION_PROPERTY = "filterCondition";
    private final Logger logger = LoggerFactory.getLogger(EventWrapperViewTable.class);
    protected EventWrapperTableModel<T> tableModel;
    protected Map<Object, TooltipGenerator> tooltipGenerators;
    protected Map<Object, TableColumn> tableColumns;
    protected PersistentTableColumnModel tableColumnModel;
    private boolean scrollingToBottom;
    private Condition filterCondition;
    private JPopupMenu popupMenu;
    private JMenuItem showHideMenu;
    private boolean global;
    protected MainFrame mainFrame;
    private static final Colors NOT_MATCHING_COLORS = new Colors(new Color(192, 192, 192), new Color(245, 245, 245), true);
    private static final Colors EVEN_ROW_COLORS = new Colors(new Color(0, 0, 0), new Color(255, 255, 255));
    private static final Colors ODD_ROW_COLORS = new Colors(new Color(0, 0, 0), new Color(233, 237, 242));

    public EventWrapperViewTable(MainFrame mainFrame, EventWrapperTableModel<T> model, boolean global) {
        this.mainFrame = mainFrame;
        this.global = global;
        this.tableModel = model;
        this.tableModel.addTableModelListener(new ScrollToBottomListener());
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(this.tableModel);
        this.setSelectionMode(0);
        this.addFocusListener(new RepaintFocusListener());
        this.initTableColumns();
        this.tableColumnModel = new PersistentTableColumnModel();
        this.resetLayout();
        this.initTooltipGenerators();
        this.setShowHorizontalLines(false);
        this.setAutoResizeMode(0);
        this.popupMenu = new JPopupMenu();
        this.showHideMenu = new JMenu("Show/Hide");
        this.popupMenu.add(this.showHideMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(new SaveLayoutAction());
        this.popupMenu.add(new ResetLayoutAction());
        this.getTableHeader().addMouseListener(new PopupListener());
    }

    public boolean isGlobal() {
        return this.global;
    }

    protected abstract void initTooltipGenerators();

    protected abstract void initTableColumns();

    private void updatePopupMenu() {
        this.showHideMenu.removeAll();
        List<PersistentTableColumnModel.TableColumnLayoutInfo> cli = this.tableColumnModel.getColumnLayoutInfos();
        for (PersistentTableColumnModel.TableColumnLayoutInfo current : cli) {
            boolean visible = current.isVisible();
            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(new ShowHideAction(current.getColumnName(), visible));
            cbmi.setSelected(visible);
            this.showHideMenu.add(cbmi);
        }
    }

    public PersistentTableColumnModel getTableColumnModel() {
        return this.tableColumnModel;
    }

    public Condition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(Condition filterCondition) {
        Condition oldValue = this.filterCondition;
        this.filterCondition = filterCondition;
        this.repaint();
        this.firePropertyChange(FILTER_CONDITION_PROPERTY, oldValue, filterCondition);
    }

    public void scrollToBottom() {
        int row = this.getRowCount();
        this.selectRow(--row);
    }

    public void selectRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting row {}.", row);
            }
            this.getSelectionModel().setSelectionInterval(0, row);
            this.scrollRectToVisible(this.getCellRect(row, 0, true));
        }
    }

    public boolean isScrollingToBottom() {
        return this.scrollingToBottom;
    }

    public void setScrollingToBottom(boolean scrollingToBottom) {
        if (this.scrollingToBottom != scrollingToBottom) {
            Boolean oldValue = this.scrollingToBottom;
            this.scrollingToBottom = scrollingToBottom;
            if (scrollingToBottom) {
                this.scrollToBottom();
            }
            this.firePropertyChange(SCROLLING_TO_BOTTOM_PROPERTY, oldValue, (Object)scrollingToBottom);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        InputMap inputMap;
        Object key;
        if (this.logger.isDebugEnabled()) {
            Object[] args = new Object[]{ks, e, condition, pressed};
            this.logger.debug("Processing KeyBinding:\n\tKeyStroke: {}\n\nEvent    : {}\n\tcondition: {}\n\tpressed  : {}\n", args);
        }
        if ((key = (inputMap = this.getInputMap(condition)).get(ks)) != null) {
            String keyStr = "" + key;
            if (keyStr.startsWith("select")) {
                if (this.isScrollingToBottom()) {
                    this.setScrollingToBottom(false);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("select detected! {}", (Object)keyStr);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ActionKey: {}", (Object)keyStr);
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TooltipGenerator generator;
        TableColumn tableColumn;
        if (this.tooltipGenerators == null) {
            return null;
        }
        Point p = event.getPoint();
        int row = this.rowAtPoint(p);
        int column = this.columnAtPoint(p);
        if (column > -1 && (tableColumn = this.getColumnModel().getColumn(column)) != null && (generator = this.tooltipGenerators.get(tableColumn.getIdentifier())) != null) {
            return generator.createTooltipText(this, row);
        }
        return null;
    }

    public abstract void saveLayout();

    protected abstract List<PersistentTableColumnModel.TableColumnLayoutInfo> getDefaultLayout();

    protected abstract List<PersistentTableColumnModel.TableColumnLayoutInfo> loadLayout();

    protected void fireViewContainerChange() {
        ViewContainer viewContainer = this.resolveViewContainer();
        if (viewContainer != null) {
            viewContainer.fireChange();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Fired change on ViewContainer!");
            }
        }
    }

    public void resetLayout() {
        List<PersistentTableColumnModel.TableColumnLayoutInfo> infos = this.loadLayout();
        if (infos == null) {
            infos = this.getDefaultLayout();
        }
        PersistentTableColumnModel newModel = new PersistentTableColumnModel();
        for (PersistentTableColumnModel.TableColumnLayoutInfo current : infos) {
            String name = current.getColumnName();
            TableColumn col = this.tableColumns.get(name);
            if (col != null) {
                col.setPreferredWidth(current.getWidth());
            }
            newModel.addColumn(col);
            newModel.setColumnVisible(col, current.isVisible());
        }
        this.setColumnModel(newModel);
        this.tableColumnModel = newModel;
        this.fireViewContainerChange();
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.logger.isDebugEnabled()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("changeSelection({}, {}, {}, {})", new Object[]{rowIndex, columnIndex, toggle, extend});
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("changeSelection-Stacktrace", new Throwable());
            }
        }
        if (this.isScrollingToBottom()) {
            this.setScrollingToBottom(false);
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    @Override
    public Colors resolveColors(Object object, int row, int column) {
        if (object instanceof EventWrapper) {
            if (this.filterCondition != null && !this.filterCondition.isTrue(object)) {
                return NOT_MATCHING_COLORS;
            }
            Colors colors = this.mainFrame.getColors((EventWrapper)object);
            if (colors != null) {
                return colors;
            }
            if (row % 2 == 0) {
                return EVEN_ROW_COLORS;
            }
            return ODD_ROW_COLORS;
        }
        return null;
    }

    protected ViewContainer resolveViewContainer() {
        ViewContainer result = null;
        Container parentContainer = this.getParent();
        while (true) {
            if (parentContainer instanceof ViewContainer) {
                result = (ViewContainer)parentContainer;
                break;
            }
            if (parentContainer == null) break;
            parentContainer = parentContainer.getParent();
        }
        return result;
    }

    private class ShowHideAction
    extends AbstractAction {
        private boolean visible;
        private String columnName;

        private ShowHideAction(String columnName, boolean visible) {
            super(columnName);
            this.columnName = columnName;
            this.visible = visible;
        }

        public void actionPerformed(ActionEvent e) {
            this.visible = !this.visible;
            Iterator<TableColumn> iter = EventWrapperViewTable.this.tableColumnModel.getColumns(false);
            TableColumn found = null;
            while (iter.hasNext()) {
                TableColumn current = iter.next();
                if (!this.columnName.equals(current.getIdentifier())) continue;
                found = current;
                break;
            }
            if (found != null) {
                EventWrapperViewTable.this.tableColumnModel.setColumnVisible(found, this.visible);
                EventWrapperViewTable.this.fireViewContainerChange();
            }
        }
    }

    private class ResetLayoutAction
    extends AbstractAction {
        private ResetLayoutAction() {
            super("Reset layout");
        }

        public void actionPerformed(ActionEvent e) {
            if (EventWrapperViewTable.this.logger.isDebugEnabled()) {
                EventWrapperViewTable.this.logger.debug("Reset layout");
            }
            EventWrapperViewTable.this.resetLayout();
        }
    }

    private class SaveLayoutAction
    extends AbstractAction {
        private SaveLayoutAction() {
            super("Save layout");
        }

        public void actionPerformed(ActionEvent e) {
            if (EventWrapperViewTable.this.logger.isDebugEnabled()) {
                EventWrapperViewTable.this.logger.debug("Save layout");
            }
            EventWrapperViewTable.this.saveLayout();
        }
    }

    private class PopupListener
    implements MouseListener {
        private PopupListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e.getPoint());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e.getPoint());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e.getPoint());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void showPopup(Point p) {
            if (EventWrapperViewTable.this.logger.isDebugEnabled()) {
                EventWrapperViewTable.this.logger.debug("Showing popup at {}.", p);
            }
            EventWrapperViewTable.this.updatePopupMenu();
            EventWrapperViewTable.this.popupMenu.show(EventWrapperViewTable.this.getTableHeader(), p.x, p.y);
        }
    }

    private class RepaintFocusListener
    implements FocusListener {
        private RepaintFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            EventWrapperViewTable.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            EventWrapperViewTable.this.repaint();
        }
    }

    private class ScrollToBottomListener
    implements TableModelListener {
        private ScrollToBottomListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (EventWrapperViewTable.this.scrollingToBottom) {
                EventWrapperViewTable.this.scrollToBottom();
            }
        }
    }
}

