/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.linklistener;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.logback.LogbackLoggingAdapter;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.linklistener.OpenUrlLinkListener;
import de.huxhorn.sulky.formatting.SimpleXml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.swing.LinkListener;

public class StackTraceElementLinkListener
extends LinkListener {
    private final Logger logger = LoggerFactory.getLogger(OpenUrlLinkListener.class);
    public static final String STACK_TRACE_ELEMENT_URI_PREFIX = "ste://";
    private MainFrame mainFrame;

    public StackTraceElementLinkListener(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void linkClicked(BasicPanel basicPanel, String uri) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Link clicked: {}", (Object)uri);
        }
        if (uri.startsWith(STACK_TRACE_ELEMENT_URI_PREFIX)) {
            String steStr = uri.substring(STACK_TRACE_ELEMENT_URI_PREFIX.length());
            steStr = SimpleXml.unescape((String)steStr);
            ExtendedStackTraceElement ste = LogbackLoggingAdapter.parseStackTraceElement((String)steStr);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("STE: {}", ste);
            }
            this.mainFrame.goToSource(ste.getStackTraceElement());
        }
    }
}

