/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.debug;

import de.huxhorn.lilith.debug.LogAnonymousRunnable;
import de.huxhorn.lilith.debug.LogParamThrowableRunnable;
import de.huxhorn.lilith.debug.LogSkullRunnable;
import de.huxhorn.lilith.debug.LogStuffRunnable;
import de.huxhorn.lilith.debug.LogStuffWithMdcRunnable;
import de.huxhorn.lilith.debug.LogThrowableRunnable;
import de.huxhorn.lilith.debug.LogTruthRunnable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LoggerEventEmitter {
    private static final int DEFAULT_DELAY = 50;
    private int delay = 50;
    private Marker marker = this.createMarker();
    private Marker fnordMarker = this.createFnordMarker();
    private ExecutorService executor = Executors.newCachedThreadPool();

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void logStuff() throws InterruptedException {
        this.execute(new LogStuffRunnable(this.delay, null));
    }

    private void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void logStuffWithMdc() throws InterruptedException {
        this.execute(new LogStuffWithMdcRunnable(this.delay, null));
    }

    private Marker createMarker() {
        Marker marker = MarkerFactory.getMarker("FooBar");
        Marker marker1 = MarkerFactory.getMarker("Foo");
        Marker marker2 = MarkerFactory.getMarker("Bar");
        Marker marker3 = MarkerFactory.getMarker("Recursive");
        marker.add(marker1);
        marker.add(marker2);
        marker.add(marker3);
        marker3.add(marker);
        return marker;
    }

    private Marker createFnordMarker() {
        Marker eris = MarkerFactory.getMarker("Hail Eris!!");
        Marker discordia = MarkerFactory.getMarker("All Hail Discordia!!!");
        eris.add(discordia);
        return eris;
    }

    public void logStuffWithMdcAndMarker() throws InterruptedException {
        this.execute(new LogStuffWithMdcRunnable(this.delay, this.marker));
    }

    public void logStuffWithMarker() throws InterruptedException {
        this.execute(new LogStuffRunnable(this.delay, this.marker));
    }

    public void logException() throws InterruptedException {
        RuntimeException ex = new RuntimeException("Test-Exception");
        this.execute(new LogThrowableRunnable(this.delay, ex));
    }

    public void logException2() throws InterruptedException {
        RuntimeException ex = new RuntimeException("Another Test-Exception", new RuntimeException("Test-Exception"));
        this.execute(new LogThrowableRunnable(this.delay, ex));
    }

    public void logParamException() throws InterruptedException {
        RuntimeException ex = new RuntimeException("Test-Exception");
        this.execute(new LogParamThrowableRunnable(this.delay, ex));
    }

    public void logParamException2() throws InterruptedException {
        RuntimeException ex = new RuntimeException("Another Test-Exception", new RuntimeException("Test-Exception"));
        this.execute(new LogParamThrowableRunnable(this.delay, ex));
    }

    public void logAnonymous() {
        this.execute(new LogAnonymousRunnable(this.delay));
    }

    public void logSkull() {
        this.execute(new LogSkullRunnable(this.delay));
    }

    public void logTruth() {
        this.execute(new LogTruthRunnable(this.delay, this.fnordMarker, true));
        this.execute(new LogTruthRunnable(this.delay, this.fnordMarker, false));
    }
}

