/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.logback;

import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import ch.qos.logback.classic.spi.ThrowableProxy;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.MessageFormatter;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackLoggingAdapter {
    private static final String CLASSNAME_MESSAGE_SEPARATOR = ": ";
    private static final String COMMON_FRAMES_PREFIX = "\t... ";
    private static final String COMMON_FRAMES_OMITTED = " common frames omitted";
    private static final String NATIVE_METHOD = "Native Method";
    private static final String UNKNOWN_SOURCE = "Unknown Source";
    private static final String CAUSED_BY = "Caused by: ";

    public LoggingEvent convert(ch.qos.logback.classic.spi.LoggingEvent event) {
        if (event == null) {
            return null;
        }
        LoggingEvent result = new LoggingEvent();
        String messagePattern = event.getMessage();
        result.setMessagePattern(messagePattern);
        Object[] originalArguments = event.getArgumentArray();
        MessageFormatter.ArgumentResult argumentResult = MessageFormatter.evaluateArguments((String)messagePattern, (Object[])originalArguments);
        if (argumentResult != null) {
            result.setArguments(argumentResult.getArguments());
            Throwable t = argumentResult.getThrowable();
            if (t != null && event.getThrowableProxy() == null) {
                event.setThrowableProxy(new ThrowableProxy(t));
            }
        }
        this.initThrowableFromEvent(event, result);
        this.initCallStack(event, result);
        result.setLevel(LoggingEvent.Level.valueOf((String)event.getLevel().toString()));
        result.setLogger(event.getLoggerRemoteView().getName());
        this.initMarker(event, result);
        result.setMdc(event.getMDCPropertyMap());
        result.setThreadName(event.getThreadName());
        result.setTimeStamp(new Date(event.getTimeStamp()));
        return result;
    }

    private void initThrowableFromEvent(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        ThrowableProxy ti = src.getThrowableProxy();
        if (ti == null) {
            return;
        }
        ti.calculatePackagingData();
        this.initFromThrowableDataPoints(ti, dst);
    }

    private ExtendedStackTraceElement[] convert(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return null;
        }
        ExtendedStackTraceElement[] result = new ExtendedStackTraceElement[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            result[i] = new ExtendedStackTraceElement(stackTrace[i]);
        }
        return result;
    }

    void initFromThrowableDataPoints(ThrowableProxy ti, LoggingEvent dst) {
        ThrowableDataPoint[] throwStrRep = ti.getThrowableDataPointArray();
        if (throwStrRep == null) {
            return;
        }
        dst.setThrowable(this.initFromThrowableDataPointsRecursive(throwStrRep, 0));
    }

    ThrowableInfo initFromThrowableDataPointsRecursive(ThrowableDataPoint[] throwStrRep, int index) {
        if (index >= throwStrRep.length) {
            return null;
        }
        ThrowableDataPoint currentDataPoint = throwStrRep[index];
        String current = currentDataPoint.toString();
        if (current.startsWith(CAUSED_BY)) {
            current = current.substring(CAUSED_BY.length());
        }
        int colonIdx = current.indexOf(CLASSNAME_MESSAGE_SEPARATOR);
        ThrowableInfo result = new ThrowableInfo();
        if (colonIdx == -1) {
            result.setName(current);
        } else {
            result.setName(current.substring(0, colonIdx));
            result.setMessage(current.substring(colonIdx + CLASSNAME_MESSAGE_SEPARATOR.length()));
        }
        ArrayList<ExtendedStackTraceElement> stackElements = new ArrayList<ExtendedStackTraceElement>();
        for (int i = ++index; i < throwStrRep.length; ++i) {
            ThrowableDataPoint dataPoint = throwStrRep[i];
            ThrowableDataPoint.ThrowableDataPointType type = dataPoint.getType();
            if (type == ThrowableDataPoint.ThrowableDataPointType.RAW) {
                String raw = throwStrRep[i].toString();
                if (raw.startsWith(CAUSED_BY)) {
                    result.setStackTrace(stackElements.toArray(new ExtendedStackTraceElement[stackElements.size()]));
                    stackElements.clear();
                    result.setCause(this.initFromThrowableDataPointsRecursive(throwStrRep, i));
                    break;
                }
                if (raw.endsWith(COMMON_FRAMES_OMITTED)) {
                    String omittedElementsStr = raw.substring(COMMON_FRAMES_PREFIX.length(), raw.length() - COMMON_FRAMES_OMITTED.length());
                    int omittedElements = 0;
                    try {
                        omittedElements = Integer.parseInt(omittedElementsStr);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    result.setOmittedElements(omittedElements);
                    continue;
                }
            }
            stackElements.add(LogbackLoggingAdapter.parseStac(dataPoint.getStackTraceElementProxy()));
        }
        return result;
    }

    public static ExtendedStackTraceElement parseStac(StackTraceElementProxy proxy) {
        if (proxy == null) {
            return null;
        }
        ExtendedStackTraceElement result = new ExtendedStackTraceElement();
        StackTraceElement ste = proxy.getStackTraceElement();
        result.setClassName(ste.getClassName());
        result.setMethodName(ste.getMethodName());
        result.setLineNumber(ste.getLineNumber());
        result.setFileName(ste.getFileName());
        ClassPackagingData cpd = proxy.getClassPackagingData();
        if (cpd != null) {
            result.setCodeLocation(cpd.getCodeLocation());
            result.setVersion(cpd.getVersion());
            result.setExact(cpd.isExact());
        }
        return result;
    }

    public static ExtendedStackTraceElement parseStackTraceElement(String current) {
        int idx = current.lastIndexOf("(");
        String classAndMethod = current.substring(0, idx);
        String source = current.substring(idx + 1, current.length() - 1);
        idx = classAndMethod.lastIndexOf(".");
        String clazz = classAndMethod.substring(0, idx);
        String method = classAndMethod.substring(idx + 1, classAndMethod.length());
        idx = source.lastIndexOf(":");
        String file = null;
        int lineNumber = -1;
        if (idx != -1) {
            file = source.substring(0, idx);
            lineNumber = Integer.parseInt(source.substring(idx + 1, source.length()));
        } else if (source.equals(NATIVE_METHOD)) {
            lineNumber = -2;
        } else if (!source.equals(UNKNOWN_SOURCE)) {
            file = source;
        }
        return new ExtendedStackTraceElement(clazz, method, file, lineNumber);
    }

    private void initCallStack(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        CallerData[] cd = src.getCallerData();
        if (cd == null) {
            return;
        }
        StackTraceElement[] callStack = new StackTraceElement[cd.length];
        for (int i = 0; i < cd.length; ++i) {
            CallerData current = cd[i];
            int lineNumber = current.getLineNumber();
            if (current.isNativeMethod()) {
                lineNumber = -2;
            }
            callStack[i] = new StackTraceElement(current.getClassName(), current.getMethodName(), current.getFileName(), lineNumber);
        }
        dst.setCallStack(this.convert(callStack));
    }

    private void initMarker(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        org.slf4j.Marker origMarker = src.getMarker();
        if (origMarker == null) {
            return;
        }
        HashMap<String, Marker> markers = new HashMap<String, Marker>();
        dst.setMarker(this.initMarkerRecursive(origMarker, markers));
    }

    private Marker initMarkerRecursive(org.slf4j.Marker origMarker, Map<String, Marker> markers) {
        if (origMarker == null) {
            return null;
        }
        String name = origMarker.getName();
        if (markers.containsKey(name)) {
            return markers.get(name);
        }
        Marker newMarker = new Marker(name);
        markers.put(name, newMarker);
        if (origMarker.hasReferences()) {
            for (org.slf4j.Marker current : origMarker) {
                newMarker.add(this.initMarkerRecursive(current, markers));
            }
        }
        return newMarker;
    }
}

