/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.java.Groovifier;
import org.codehaus.groovy.antlr.java.Java2GroovyConverter;
import org.codehaus.groovy.antlr.java.JavaLexer;
import org.codehaus.groovy.antlr.java.JavaRecognizer;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.codehaus.groovy.antlr.treewalker.PreOrderTraversal;
import org.codehaus.groovy.antlr.treewalker.SourceCodeTraversal;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.tools.groovydoc.GroovyDocTool;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDocAssembler;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyPackageDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyRootDoc;

public class GroovyRootDocBuilder {
    private final GroovyDocTool tool;
    private final Path sourcepath;
    private final SimpleGroovyRootDoc rootDoc;
    private static final char FS = '/';
    private List links;

    public GroovyRootDocBuilder(GroovyDocTool tool, Path sourcepath, List links) {
        this.tool = tool;
        this.sourcepath = sourcepath;
        this.links = links;
        this.rootDoc = new SimpleGroovyRootDoc("root");
    }

    public Map getClassDocsFromSingleSource(String packagePath, String file, String src) throws RecognitionException, TokenStreamException {
        Map classDocsFromSrc = null;
        classDocsFromSrc = file.indexOf(".java") > 0 ? this.parseJava(packagePath, file, src) : (file.indexOf(".sourcefile") > 0 ? this.parseJava(packagePath, file, src) : this.parseGroovy(packagePath, file, src));
        return classDocsFromSrc;
    }

    private Map parseJava(String packagePath, String file, String src) throws RecognitionException, TokenStreamException {
        SourceBuffer sourceBuffer = new SourceBuffer();
        JavaRecognizer parser = this.getJavaParser(src, sourceBuffer);
        String[] tokenNames = parser.getTokenNames();
        parser.compilationUnit();
        AST ast = parser.getAST();
        Java2GroovyConverter java2groovyConverter = new Java2GroovyConverter(tokenNames);
        PreOrderTraversal java2groovyTraverser = new PreOrderTraversal(java2groovyConverter);
        java2groovyTraverser.process(ast);
        Groovifier groovifier = new Groovifier(tokenNames);
        PreOrderTraversal groovifierTraverser = new PreOrderTraversal(groovifier);
        groovifierTraverser.process(ast);
        SimpleGroovyClassDocAssembler visitor = new SimpleGroovyClassDocAssembler(packagePath, file, sourceBuffer, this.links);
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
        return visitor.getGroovyClassDocs();
    }

    private Map parseGroovy(String packagePath, String file, String src) throws RecognitionException, TokenStreamException {
        SourceBuffer sourceBuffer = new SourceBuffer();
        GroovyRecognizer parser = this.getGroovyParser(src, sourceBuffer);
        String[] tokenNames = parser.getTokenNames();
        parser.compilationUnit();
        AST ast = parser.getAST();
        SimpleGroovyClassDocAssembler visitor = new SimpleGroovyClassDocAssembler(packagePath, file, sourceBuffer, this.links);
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
        return visitor.getGroovyClassDocs();
    }

    private JavaRecognizer getJavaParser(String input, SourceBuffer sourceBuffer) {
        JavaRecognizer parser = null;
        UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(new StringReader(input), sourceBuffer);
        JavaLexer lexer = new JavaLexer(unicodeReader);
        unicodeReader.setLexer(lexer);
        parser = JavaRecognizer.make(lexer);
        parser.setSourceBuffer(sourceBuffer);
        return parser;
    }

    private GroovyRecognizer getGroovyParser(String input, SourceBuffer sourceBuffer) {
        GroovyRecognizer parser = null;
        UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(new StringReader(input), sourceBuffer);
        GroovyLexer lexer = new GroovyLexer(unicodeReader);
        unicodeReader.setLexer(lexer);
        parser = GroovyRecognizer.make(lexer);
        parser.setSourceBuffer(sourceBuffer);
        return parser;
    }

    public void buildTree(List filenames) throws IOException, RecognitionException, TokenStreamException {
        for (String filename : filenames) {
            for (FileResource fileRes : this.sourcepath) {
                String path = fileRes.getFile().getAbsolutePath();
                if (!new File(path + '/' + filename).exists()) continue;
                String srcFileName = path + '/' + filename;
                String src = DefaultGroovyMethods.getText(new File(srcFileName));
                String packagePath = this.tool.getPath(filename);
                packagePath = packagePath.replace('\\', '/');
                String file = this.tool.getFile(filename);
                try {
                    Map classDocs = this.getClassDocsFromSingleSource(packagePath, file, src);
                    this.rootDoc.putAllClasses(classDocs);
                    SimpleGroovyPackageDoc packageDoc = (SimpleGroovyPackageDoc)this.rootDoc.packageNamed(packagePath);
                    if (packageDoc == null) {
                        packageDoc = new SimpleGroovyPackageDoc(packagePath);
                    }
                    packageDoc.putAll(classDocs);
                    this.rootDoc.put(packagePath, packageDoc);
                }
                catch (RecognitionException e) {
                    System.out.println("ignored due to RecognitionException: " + filename);
                }
                catch (TokenStreamException e) {
                    System.out.println("ignored due to TokenStreamException: " + filename);
                }
            }
        }
    }

    public GroovyRootDoc getRootDoc() {
        this.rootDoc.resolve();
        return this.rootDoc;
    }
}

