/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.swing;

import de.huxhorn.sulky.swing.ProgressingCallable;
import de.huxhorn.sulky.swing.ResultListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingWorkManager<V> {
    private final Logger logger = LoggerFactory.getLogger(SwingWorkManager.class);
    private ExecutorService executor;
    private final List<Future<V>> futures = new LinkedList<Future<V>>();
    private final List<ResultListener> resultListeners;
    private final List<PropertyChangeEvent> internalProgressChanges;
    private final Map<Future<V>, Callable<V>> futureCallableMapping = new HashMap<Future<V>, Callable<V>>();
    private PropertyChangeListener progressChangeListener = new ProgressChangeListener();

    public SwingWorkManager() {
        this.internalProgressChanges = new ArrayList<PropertyChangeEvent>();
        this.resultListeners = new LinkedList<ResultListener>();
        this.executor = Executors.newCachedThreadPool();
        Thread t = new Thread((Runnable)new ResultPoller(), "ResultPoller Runnable");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<V> add(Callable<V> callable) {
        if (callable instanceof ProgressingCallable) {
            ProgressingCallable pcallable = (ProgressingCallable)callable;
            pcallable.addPropertyChangeListener(this.progressChangeListener);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Added progress change listener to callable.");
            }
        }
        Future<V> future = this.executor.submit(callable);
        Map<Future<V>, Callable<V>> map = this.futureCallableMapping;
        synchronized (map) {
            this.futureCallableMapping.put(future, callable);
        }
        this.watch(future);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(Future<V> future) {
        List<Future<V>> list = this.futures;
        synchronized (list) {
            this.futures.add(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultListener(ResultListener listener) {
        List<ResultListener> list = this.resultListeners;
        synchronized (list) {
            this.resultListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultListener(ResultListener listener) {
        List<ResultListener> list = this.resultListeners;
        synchronized (list) {
            this.resultListeners.remove(listener);
        }
    }

    private class ProgressChangeListener
    implements PropertyChangeListener {
        private ProgressChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress".equals(evt.getPropertyName())) {
                List list = SwingWorkManager.this.internalProgressChanges;
                synchronized (list) {
                    SwingWorkManager.this.internalProgressChanges.add(evt);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultListenerFireRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(SwingWorkManager.class);
        private List<Future<V>> done;
        private List<ResultListener> clonedListeners;
        private List<PropertyChangeEvent> progressChanges;

        public ResultListenerFireRunnable(List<Future<V>> done, List<PropertyChangeEvent> progressChanges) {
            this.done = done;
            this.progressChanges = progressChanges;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List list = SwingWorkManager.this.resultListeners;
            synchronized (list) {
                this.clonedListeners = new ArrayList<ResultListener>(SwingWorkManager.this.resultListeners);
            }
            if (this.progressChanges != null) {
                for (PropertyChangeEvent propertyChangeEvent : this.progressChanges) {
                    Object source = propertyChangeEvent.getSource();
                    Object object = propertyChangeEvent.getNewValue();
                    if (source instanceof ProgressingCallable && object instanceof Integer && "progress".equals(propertyChangeEvent.getPropertyName())) {
                        ProgressingCallable progressingCallable = (ProgressingCallable)source;
                        int progress = (Integer)object;
                        this.fireProgressEvent(progressingCallable, progress);
                        continue;
                    }
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Somethings wrong with the propChangeEvent! source={}, newValue={}", source, object);
                }
            }
            if (this.done != null) {
                Callable callable;
                HashMap doneMapping = new HashMap();
                Map map = SwingWorkManager.this.futureCallableMapping;
                synchronized (map) {
                    for (Future future : this.done) {
                        callable = (Callable)SwingWorkManager.this.futureCallableMapping.remove(future);
                        if (callable == null) {
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error("callable not found!");
                            }
                        } else if (callable instanceof ProgressingCallable) {
                            ProgressingCallable pc = (ProgressingCallable)callable;
                            pc.removePropertyChangeListener(SwingWorkManager.this.progressChangeListener);
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Removed progress change listener from callable.");
                            }
                        }
                        doneMapping.put(future, callable);
                    }
                }
                for (Map.Entry current2 : doneMapping.entrySet()) {
                    Future future = (Future)current2.getKey();
                    callable = (Callable)current2.getValue();
                    if (future.isCancelled()) {
                        this.fireCanceledEvent(callable);
                        continue;
                    }
                    try {
                        this.fireFinishedEvent(callable, future.get());
                    }
                    catch (InterruptedException e) {
                        if (!this.logger.isInfoEnabled()) continue;
                        this.logger.info("Interrupted...", (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        this.fireExceptionEvent(callable, e);
                    }
                }
            }
        }

        private void fireProgressEvent(ProgressingCallable<V> callable, int progress) {
            for (ResultListener listener : this.clonedListeners) {
                listener.progressUpdated(callable, progress);
            }
        }

        private void fireExceptionEvent(Callable<V> callable, ExecutionException exception) {
            for (ResultListener listener : this.clonedListeners) {
                listener.executionFailed(callable, exception);
            }
        }

        private void fireFinishedEvent(Callable<V> callable, V result) {
            for (ResultListener listener : this.clonedListeners) {
                listener.executionFinished(callable, result);
            }
        }

        private void fireCanceledEvent(Callable<V> callable) {
            for (ResultListener listener : this.clonedListeners) {
                listener.executionCanceled(callable);
            }
        }
    }

    class ResultPoller
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(ResultPoller.class);
        private static final long POLL_INTERVAL = 200L;

        ResultPoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    ArrayList done = null;
                    List list = SwingWorkManager.this.futures;
                    synchronized (list) {
                        for (Future future : SwingWorkManager.this.futures) {
                            if (!future.isDone()) continue;
                            if (done == null) {
                                done = new ArrayList();
                            }
                            done.add(future);
                        }
                        if (done != null) {
                            SwingWorkManager.this.futures.removeAll(done);
                        }
                    }
                    ArrayList<PropertyChangeEvent> progressChanges = null;
                    List list2 = SwingWorkManager.this.internalProgressChanges;
                    synchronized (list2) {
                        if (SwingWorkManager.this.internalProgressChanges.size() > 0) {
                            progressChanges = new ArrayList<PropertyChangeEvent>(SwingWorkManager.this.internalProgressChanges);
                            SwingWorkManager.this.internalProgressChanges.clear();
                        }
                    }
                    if (done != null || progressChanges != null) {
                        SwingUtilities.invokeLater(new ResultListenerFireRunnable(done, progressChanges));
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                block14: {
                    if (!this.logger.isInfoEnabled()) break block14;
                    this.logger.info("Interrupted...", (Throwable)e);
                }
                return;
            }
        }
    }
}

