/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.swing;

import de.huxhorn.sulky.swing.ProgressingCallable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProgressingCallable<T>
implements ProgressingCallable<T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractProgressingCallable.class);
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private int progress = 0;
    private long numberOfSteps = 1L;
    private long currentStep;
    private int initialSleepSteps;
    private int laterSleepSteps;
    private long lastSleepStep;

    public AbstractProgressingCallable() {
        this(0, 0);
    }

    public AbstractProgressingCallable(int sleepSteps) {
        this(sleepSteps, 0);
    }

    public AbstractProgressingCallable(int initialSleepSteps, int laterSleepSteps) {
        this.initialSleepSteps = initialSleepSteps;
        this.laterSleepSteps = laterSleepSteps;
        this.lastSleepStep = 0L;
    }

    protected void setNumberOfSteps(long numberOfSteps) {
        if (numberOfSteps < 1L) {
            throw new IllegalArgumentException("numberOfSteps (" + numberOfSteps + ") must be positive!");
        }
        this.numberOfSteps = numberOfSteps;
    }

    protected void setCurrentStep(long currentStep) throws InterruptedException {
        this.currentStep = currentStep;
        this.calculateProgress();
        if (currentStep != 0L && this.initialSleepSteps > 0) {
            if (this.laterSleepSteps > 0 && currentStep > (long)(this.initialSleepSteps * 5)) {
                if (this.lastSleepStep + (long)this.laterSleepSteps < currentStep) {
                    this.lastSleepStep = currentStep;
                    Thread.sleep(1L);
                }
            } else if (this.lastSleepStep + (long)this.initialSleepSteps < currentStep) {
                this.lastSleepStep = currentStep;
                Thread.sleep(1L);
            }
        }
    }

    private void calculateProgress() {
        int newProgress = (int)((double)this.currentStep / (double)this.numberOfSteps * 100.0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New progress: {}", (Object)newProgress);
        }
        this.setProgress(newProgress);
    }

    protected void setProgress(int progress) {
        if (this.progress != progress) {
            Integer oldValue = this.progress;
            this.progress = progress;
            Integer newValue = this.progress;
            this.changeSupport.firePropertyChange("progress", oldValue, newValue);
        }
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }
}

