/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.BasicBufferIterator;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.conditions.Condition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringBuffer<E>
implements Buffer<E>,
DisposeOperation {
    private Buffer<E> sourceBuffer;
    private Condition condition;
    private final List<Long> filteredIndices;
    private boolean disposed;

    public FilteringBuffer(Buffer<E> sourceBuffer, Condition condition) {
        this.sourceBuffer = sourceBuffer;
        this.condition = condition;
        this.filteredIndices = new ArrayList<Long>();
        this.disposed = false;
        Thread t = new Thread(new FilterUpdateRunnable(1000));
        t.setDaemon(true);
        t.start();
    }

    @Override
    public E get(long index) {
        long realIndex = this.getSourceIndex(index);
        if (realIndex >= 0L) {
            return this.sourceBuffer.get(realIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSourceIndex(long index) {
        long realIndex = -1L;
        List<Long> list = this.filteredIndices;
        synchronized (list) {
            if (index >= 0L && index < (long)this.filteredIndices.size()) {
                realIndex = this.filteredIndices.get((int)index);
            }
        }
        return realIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        List<Long> list = this.filteredIndices;
        synchronized (list) {
            return this.filteredIndices.size();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new BasicBufferIterator(this);
    }

    public Buffer<E> getSourceBuffer() {
        return this.sourceBuffer;
    }

    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public synchronized void dispose() {
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    private class FilterUpdateRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(FilterUpdateRunnable.class);
        private int filterDelay;
        private long lastFilteredElement;

        public FilterUpdateRunnable(int filterDelay) {
            this.filterDelay = filterDelay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!FilteringBuffer.this.disposed) {
                long currentSize = FilteringBuffer.this.sourceBuffer.getSize();
                long filterStartIndex = this.lastFilteredElement;
                if (currentSize < this.lastFilteredElement) {
                    filterStartIndex = 0L;
                    List list = FilteringBuffer.this.filteredIndices;
                    synchronized (list) {
                        FilteringBuffer.this.filteredIndices.clear();
                    }
                }
                if (currentSize != this.lastFilteredElement + 1L) {
                    long i = filterStartIndex;
                    while (i < currentSize && !FilteringBuffer.this.disposed) {
                        Object current = FilteringBuffer.this.sourceBuffer.get(i);
                        if (current != null && FilteringBuffer.this.condition != null && FilteringBuffer.this.condition.isTrue(current)) {
                            List list = FilteringBuffer.this.filteredIndices;
                            synchronized (list) {
                                FilteringBuffer.this.filteredIndices.add(i);
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Added index: {}", (Object)i);
                                }
                            }
                        }
                        this.lastFilteredElement = i++;
                    }
                }
                try {
                    Thread.sleep(this.filterDelay);
                }
                catch (InterruptedException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Interrupted...", (Throwable)e);
                    }
                    return;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Runnable finished.");
            }
        }
    }
}

