/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.stax;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeFormatter {
    private static final String SIMPLE_DATE_FORMAT_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String TIMEZONE_DATE_FORMAT_PATTERN = ".*([+-]\\d{2})(\\d{2})$";
    private static final int TIMEZONE_DATE_FORMAT_LENGTH = 5;
    private static final String TIMEZONE_XML_FORMAT_PATTERN = ".*([+-]\\d{2}):(\\d{2})$";
    private static final int TIMEZONE_XML_FORMAT_LENGTH = 6;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private Pattern xmlTimezonePattern = Pattern.compile(".*([+-]\\d{2}):(\\d{2})$");
    private Pattern javaTimezonePattern = Pattern.compile(".*([+-]\\d{2})(\\d{2})$");

    public Date parse(String dateTime) throws ParseException {
        Matcher matcher = this.xmlTimezonePattern.matcher(dateTime);
        if (matcher.matches()) {
            String hh = matcher.group(1);
            String mm = matcher.group(2);
            dateTime = dateTime.substring(0, dateTime.length() - 6) + hh + mm;
        }
        return this.dateFormat.parse(dateTime);
    }

    public String format(Date date) {
        String result = this.dateFormat.format(date);
        Matcher matcher = this.javaTimezonePattern.matcher(result);
        if (matcher.matches()) {
            String hh = matcher.group(1);
            String mm = matcher.group(2);
            result = result.substring(0, result.length() - 5) + hh + ":" + mm;
        }
        return result;
    }
}

