/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.xml;

import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.xml.LoggingEventWriter;
import de.huxhorn.sulky.generics.io.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingXmlSerializer
implements Serializer<LoggingEvent> {
    private LoggingEventWriter loggingEventWriter;
    private XMLOutputFactory outputFactory;
    private boolean compressing;

    public LoggingXmlSerializer(boolean compressing) {
        this.compressing = compressing;
        this.outputFactory = XMLOutputFactory.newInstance();
        this.loggingEventWriter = new LoggingEventWriter();
        this.loggingEventWriter.setWritingSchemaLocation(false);
    }

    public byte[] serialize(LoggingEvent event) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLStreamWriter writer;
            OutputStreamWriter osw;
            if (this.compressing) {
                GZIPOutputStream gos = new GZIPOutputStream(out);
                osw = new OutputStreamWriter((OutputStream)gos, "utf-8");
                writer = this.outputFactory.createXMLStreamWriter(osw);
            } else {
                osw = new OutputStreamWriter((OutputStream)out, "utf-8");
                writer = this.outputFactory.createXMLStreamWriter(osw);
            }
            this.loggingEventWriter.write(writer, event, true);
            writer.flush();
            writer.close();
            osw.flush();
            osw.close();
            return out.toByteArray();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

