/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.Util;
import org.rrd4j.data.Aggregates;
import org.rrd4j.data.Aggregator;
import org.rrd4j.data.Source;

class Def
extends Source {
    private String path;
    private String dsName;
    private String backend;
    private ConsolFun consolFun;
    private FetchData fetchData;

    Def(String string, FetchData fetchData) {
        this(string, null, string, null, null);
        this.setFetchData(fetchData);
    }

    Def(String string, String string2, String string3, ConsolFun consolFun) {
        this(string, string2, string3, consolFun, null);
    }

    Def(String string, String string2, String string3, ConsolFun consolFun, String string4) {
        super(string);
        this.path = string2;
        this.dsName = string3;
        this.consolFun = consolFun;
        this.backend = string4;
    }

    String getPath() {
        return this.path;
    }

    String getCanonicalPath() throws IOException {
        return Util.getCanonicalPath(this.path);
    }

    String getDsName() {
        return this.dsName;
    }

    ConsolFun getConsolFun() {
        return this.consolFun;
    }

    String getBackend() {
        return this.backend;
    }

    boolean isCompatibleWith(Def def) throws IOException {
        return this.getCanonicalPath().equals(def.getCanonicalPath()) && this.getConsolFun() == def.consolFun && (this.backend == null && def.backend == null || this.backend != null && def.backend != null && this.backend.equals(def.backend));
    }

    void setFetchData(FetchData fetchData) {
        this.fetchData = fetchData;
    }

    long[] getRrdTimestamps() {
        return this.fetchData.getTimestamps();
    }

    double[] getRrdValues() {
        return this.fetchData.getValues(this.dsName);
    }

    long getArchiveEndTime() {
        return this.fetchData.getArcEndTime();
    }

    long getFetchStep() {
        return this.fetchData.getStep();
    }

    Aggregates getAggregates(long l, long l2) {
        long[] lArray = this.getRrdTimestamps();
        double[] dArray = this.getRrdValues();
        return new Aggregator(lArray, dArray).getAggregates(l, l2);
    }

    double getPercentile(long l, long l2, double d) {
        long[] lArray = this.getRrdTimestamps();
        double[] dArray = this.getRrdValues();
        return new Aggregator(lArray, dArray).getPercentile(l, l2, d);
    }

    boolean isLoaded() {
        return this.fetchData != null;
    }
}

