/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.timespec.TimeParser;
import org.rrd4j.core.timespec.TimeSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util {
    public static final long MAX_LONG = Long.MAX_VALUE;
    public static final long MIN_LONG = -9223372036854775807L;
    public static final double MAX_DOUBLE = Double.MAX_VALUE;
    public static final double MIN_DOUBLE = -1.7976931348623157E308;
    static final String PATTERN = "0.0000000000E00";
    static final String RRD4J_DIR = "rrd4j-demo";
    static final DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
    static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static long lastLap;

    public static double[] toDoubleArray(long[] lArray) {
        double[] dArray = new double[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            dArray[i] = lArray[i];
        }
        return dArray;
    }

    public static long getTime() {
        return (System.currentTimeMillis() + 500L) / 1000L;
    }

    public static long getTimestamp() {
        return Util.getTime();
    }

    public static long normalize(long l, long l2) {
        return l - l % l2;
    }

    public static double max(double d, double d2) {
        return Double.isNaN(d) ? d2 : (Double.isNaN(d2) ? d : Math.max(d, d2));
    }

    public static double min(double d, double d2) {
        return Double.isNaN(d) ? d2 : (Double.isNaN(d2) ? d : Math.min(d, d2));
    }

    public static double sum(double d, double d2) {
        return Double.isNaN(d) ? d2 : (Double.isNaN(d2) ? d : d + d2);
    }

    static String formatDouble(double d, String string, boolean bl) {
        if (Double.isNaN(d)) {
            return string;
        }
        if (bl) {
            return df.format(d);
        }
        return "" + d;
    }

    static String formatDouble(double d, boolean bl) {
        return Util.formatDouble(d, "NaN", bl);
    }

    public static String formatDouble(double d) {
        return Util.formatDouble(d, true);
    }

    public static Date getDate(long l) {
        return new Date(l * 1000L);
    }

    public static Calendar getCalendar(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l * 1000L);
        return calendar;
    }

    public static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static long getTimestamp(Date date) {
        return (date.getTime() + 499L) / 1000L;
    }

    public static long getTimestamp(Calendar calendar) {
        return Util.getTimestamp(calendar.getTime());
    }

    public static long getTimestamp(int n, int n2, int n3, int n4, int n5) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(n, n2, n3, n4, n5);
        return Util.getTimestamp(calendar);
    }

    public static long getTimestamp(int n, int n2, int n3) {
        return Util.getTimestamp(n, n2, n3, 0, 0);
    }

    public static long getTimestamp(String string) {
        TimeSpec timeSpec = new TimeParser(string).parse();
        return timeSpec.getTimestamp();
    }

    public static long[] getTimestamps(String string, String string2) {
        TimeSpec timeSpec = new TimeParser(string).parse();
        TimeSpec timeSpec2 = new TimeParser(string2).parse();
        return TimeSpec.getTimestamps(timeSpec, timeSpec2);
    }

    public static double parseDouble(String string) {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean parseBoolean(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("1");
    }

    public static Paint parseColor(String string) {
        String string2;
        String string3 = string2 = string.startsWith("#") ? string.substring(1) : string;
        if (string2.length() != 6 && string2.length() != 8) {
            throw new IllegalArgumentException("Invalid color specification: " + string);
        }
        String string4 = string2.substring(0, 2);
        String string5 = string2.substring(2, 4);
        String string6 = string2.substring(4, 6);
        if (string2.length() == 6) {
            return new Color(Integer.parseInt(string4, 16), Integer.parseInt(string5, 16), Integer.parseInt(string6, 16));
        }
        String string7 = string2.substring(6);
        return new Color(Integer.parseInt(string4, 16), Integer.parseInt(string5, 16), Integer.parseInt(string6, 16), Integer.parseInt(string7, 16));
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getUserHomeDirectory() {
        return System.getProperty("user.home") + Util.getFileSeparator();
    }

    public static String getRrd4jDemoDirectory() {
        String string = Util.getUserHomeDirectory() + RRD4J_DIR + Util.getFileSeparator();
        File file = new File(string);
        return file.exists() || file.mkdirs() ? string : null;
    }

    public static String getRrd4jDemoPath(String string) {
        String string2 = Util.getRrd4jDemoDirectory();
        if (string2 != null) {
            return string2 + string;
        }
        return null;
    }

    static boolean sameFilePath(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        return file.getCanonicalPath().equals(file2.getCanonicalPath());
    }

    static int getMatchingDatasourceIndex(RrdDb rrdDb, int n, RrdDb rrdDb2) throws IOException {
        String string = rrdDb.getDatasource(n).getDsName();
        try {
            return rrdDb2.getDsIndex(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    static int getMatchingArchiveIndex(RrdDb rrdDb, int n, RrdDb rrdDb2) throws IOException {
        Archive archive = rrdDb.getArchive(n);
        ConsolFun consolFun = archive.getConsolFun();
        int n2 = archive.getSteps();
        try {
            return rrdDb2.getArcIndex(consolFun, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    static String getTmpFilename() throws IOException {
        return File.createTempFile("RRD4J_", ".tmp").getCanonicalPath();
    }

    public static Calendar getCalendar(String string) {
        try {
            long l = Long.parseLong(string);
            return Util.getCalendar(l);
        }
        catch (NumberFormatException numberFormatException) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_DATE_FORMAT);
            simpleDateFormat.setLenient(false);
            try {
                Date date = simpleDateFormat.parse(string);
                return Util.getCalendar(date);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Time/date not in yyyy-MM-dd HH:mm:ss format: " + string);
            }
        }
    }

    public static String getLapTime() {
        long l = System.currentTimeMillis();
        double d = (double)(l - lastLap) / 1000.0;
        lastLap = l;
        return "[" + d + " sec]";
    }

    public static String getRrd4jHomeDirectory() {
        String string = Util.class.getName().replace('.', '/');
        String string2 = Util.class.getResource("/" + string + ".class").toString();
        if (string2.startsWith("file:/")) {
            string2 = string2.substring(6);
            File file = new File(string2);
            for (int i = 0; i < 5; ++i) {
                file = file.getParentFile();
            }
            string2 = file.getAbsolutePath();
        } else if (string2.startsWith("jar:file:/")) {
            string2 = string2.substring(9, string2.lastIndexOf(33));
            File file = new File(string2);
            for (int i = 0; i < 2; ++i) {
                file = file.getParentFile();
            }
            string2 = file.getAbsolutePath();
        } else {
            string2 = null;
        }
        return string2;
    }

    public static boolean equal(double d, double d2) {
        return Double.isNaN(d) && Double.isNaN(d2) || d == d2;
    }

    public static String getCanonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public static long getLastModified(String string) {
        return (new File(string).lastModified() + 500L) / 1000L;
    }

    public static boolean fileExists(String string) {
        return new File(string).exists();
    }

    public static double max(double[] dArray) {
        double d = Double.NaN;
        for (double d2 : dArray) {
            d = Util.max(d, d2);
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = Double.NaN;
        for (double d2 : dArray) {
            d = Util.min(d, d2);
        }
        return d;
    }

    public static String sprintf(String string, Object ... objectArray) {
        String string2 = string.replaceAll("([^%]|^)%([^a-zA-Z%]*)l(f|g|e)", "$1%$2$3");
        return String.format(string2, objectArray);
    }

    static {
        df.applyPattern(PATTERN);
        df.setPositivePrefix("+");
        lastLap = System.currentTimeMillis();
    }

    public static class Xml {
        public static Node[] getChildNodes(Node node) {
            return Xml.getChildNodes(node, null);
        }

        public static Node[] getChildNodes(Node node, String string) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || string != null && !node2.getNodeName().equals(string)) continue;
                arrayList.add(node2);
            }
            return arrayList.toArray(new Node[0]);
        }

        public static Node getFirstChildNode(Node node, String string) {
            Node[] nodeArray = Xml.getChildNodes(node, string);
            if (nodeArray.length > 0) {
                return nodeArray[0];
            }
            throw new IllegalArgumentException("XML Error, no such child: " + string);
        }

        public static boolean hasChildNode(Node node, String string) {
            Node[] nodeArray = Xml.getChildNodes(node, string);
            return nodeArray.length > 0;
        }

        public static String getChildValue(Node node, String string) {
            return Xml.getChildValue(node, string, true);
        }

        public static String getChildValue(Node node, String string, boolean bl) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals(string)) continue;
                return Xml.getValue(node2, bl);
            }
            throw new IllegalStateException("XML Error, no such child: " + string);
        }

        public static String getValue(Node node) {
            return Xml.getValue(node, true);
        }

        public static String getValue(Node node, boolean bl) {
            String string = null;
            Node node2 = node.getFirstChild();
            if (node2 != null && (string = node2.getNodeValue()) != null && bl) {
                string = string.trim();
            }
            return string;
        }

        public static int getChildValueAsInt(Node node, String string) {
            String string2 = Xml.getChildValue(node, string);
            return Integer.parseInt(string2);
        }

        public static int getValueAsInt(Node node) {
            String string = Xml.getValue(node);
            return Integer.parseInt(string);
        }

        public static long getChildValueAsLong(Node node, String string) {
            String string2 = Xml.getChildValue(node, string);
            return Long.parseLong(string2);
        }

        public static long getValueAsLong(Node node) {
            String string = Xml.getValue(node);
            return Long.parseLong(string);
        }

        public static double getChildValueAsDouble(Node node, String string) {
            String string2 = Xml.getChildValue(node, string);
            return Util.parseDouble(string2);
        }

        public static double getValueAsDouble(Node node) {
            String string = Xml.getValue(node);
            return Util.parseDouble(string);
        }

        public static boolean getChildValueAsBoolean(Node node, String string) {
            String string2 = Xml.getChildValue(node, string);
            return Util.parseBoolean(string2);
        }

        public static boolean getValueAsBoolean(Node node) {
            String string = Xml.getValue(node);
            return Util.parseBoolean(string);
        }

        public static Element getRootElement(InputSource inputSource) throws IOException {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(false);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                return document.getDocumentElement();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getMessage(), sAXException);
            }
        }

        public static Element getRootElement(String string) throws IOException {
            return Xml.getRootElement(new InputSource(new StringReader(string)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Element getRootElement(File file) throws IOException {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                Element element = Xml.getRootElement(new InputSource(fileReader));
                return element;
            }
            finally {
                if (fileReader != null) {
                    ((Reader)fileReader).close();
                }
            }
        }
    }
}

