/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdMemoryBackend;

public class RrdMemoryBackendFactory
extends RrdBackendFactory {
    public static final String NAME = "MEMORY";
    private Map<String, RrdMemoryBackend> backends = new ConcurrentHashMap<String, RrdMemoryBackend>();

    protected RrdBackend open(String string, boolean bl) throws IOException {
        RrdMemoryBackend rrdMemoryBackend;
        if (this.backends.containsKey(string)) {
            rrdMemoryBackend = this.backends.get(string);
        } else {
            rrdMemoryBackend = new RrdMemoryBackend(string);
            this.backends.put(string, rrdMemoryBackend);
        }
        return rrdMemoryBackend;
    }

    protected boolean exists(String string) {
        return this.backends.containsKey(string);
    }

    protected boolean shouldValidateHeader(String string) throws IOException {
        return false;
    }

    public boolean delete(String string) {
        if (this.backends.containsKey(string)) {
            this.backends.remove(string);
            return true;
        }
        return false;
    }

    public String getFactoryName() {
        return NAME;
    }
}

