/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences.table;

import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.lilith.swing.table.renderer.ConditionalBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ConditionPreviewRenderer
implements TableCellRenderer {
    private ConditionalBorder border;
    private JLabel renderer = new JLabel();
    private static final ColorScheme DEFAULT_SCHEME = new ColorScheme();

    public ConditionPreviewRenderer() {
        Font font = this.renderer.getFont();
        font = font.deriveFont(0);
        this.renderer.setFont(font);
        this.renderer.setOpaque(true);
        this.renderer.setText("Example");
        this.border = new ConditionalBorder(Color.WHITE, 3, 3);
        this.renderer.setBorder(this.border);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int preferredHeight;
        int rowHeight;
        ColorScheme scheme = null;
        if (value instanceof SavedCondition) {
            SavedCondition condition = (SavedCondition)value;
            scheme = condition.getColorScheme();
        }
        if (scheme == null) {
            scheme = DEFAULT_SCHEME;
        }
        this.border.setBorderColor(scheme.getBorderColor());
        this.renderer.setForeground(scheme.getTextColor());
        this.renderer.setBackground(scheme.getBackgroundColor());
        this.renderer.setBorder(null);
        this.renderer.setBorder(this.border);
        if (table != null && (rowHeight = table.getRowHeight()) < (preferredHeight = this.renderer.getPreferredSize().height)) {
            table.setRowHeight(preferredHeight);
        }
        return this.renderer;
    }
}

