/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceNameTableModel
implements TableModel {
    private final Logger logger = LoggerFactory.getLogger(SourceNameTableModel.class);
    public static final int SOURCE_IDENTIFIER_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    private Map<String, String> data;
    private List<String> keys;
    private final EventListenerList eventListenerList = new EventListenerList();

    public SourceNameTableModel(Map<String, String> data) {
        this.setData(data);
    }

    public void setData(Map<String, String> data) {
        this.data = data;
        if (data != null) {
            this.keys = new ArrayList<String>(data.keySet());
            Collections.sort(this.keys);
        } else {
            this.keys = null;
        }
        this.fireTableChange();
    }

    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Source Identifier";
            }
            case 1: {
                return "Name";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.keys == null || rowIndex < 0 || rowIndex >= this.keys.size()) {
            return null;
        }
        String key = this.keys.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return key;
            }
            case 1: {
                return this.data.get(key);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String newValue = (String)aValue;
        if (this.keys == null || rowIndex < 0 || rowIndex >= this.keys.size()) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                String key = this.keys.remove(rowIndex);
                String value = this.data.remove(key);
                if (newValue != null && !"".equals(newValue.trim())) {
                    this.data.put(newValue, value);
                    this.keys.add(newValue);
                    Collections.sort(this.keys);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Removed source name for {}.", (Object)key);
                }
                this.fireTableChange();
                break;
            }
            case 1: {
                String key = this.keys.get(rowIndex);
                if (newValue != null && !"".equals(newValue.trim())) {
                    this.data.put(key, newValue);
                } else {
                    this.keys.remove(rowIndex);
                    this.data.remove(key);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Removed source name for {}.", (Object)key);
                    }
                }
                this.fireTableChange();
            }
        }
    }

    private void fireTableChange() {
        TableModelEvent event = new TableModelEvent(this);
        this.fireTableChange(event);
    }

    private void fireTableChange(TableModelEvent evt) {
        FireTableChangeRunnable r = new FireTableChangeRunnable(evt);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.add(TableModelListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.remove(TableModelListener.class, l);
        }
    }

    private class FireTableChangeRunnable
    implements Runnable {
        private TableModelEvent event;

        public FireTableChangeRunnable(TableModelEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object[] listeners;
            EventListenerList eventListenerList = SourceNameTableModel.this.eventListenerList;
            synchronized (eventListenerList) {
                listeners = SourceNameTableModel.this.eventListenerList.getListenerList();
            }
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableModelListener.class) continue;
                TableModelListener listener = (TableModelListener)listeners[i + 1];
                if (SourceNameTableModel.this.logger.isDebugEnabled()) {
                    SourceNameTableModel.this.logger.debug("Firing TableChange at {}.", (Object)listener.getClass().getName());
                }
                try {
                    listener.tableChanged(this.event);
                    continue;
                }
                catch (Throwable ex) {
                    if (!SourceNameTableModel.this.logger.isWarnEnabled()) continue;
                    SourceNameTableModel.this.logger.warn("Exception while firing change!", ex);
                }
            }
        }
    }
}

