/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.preferences.EditSourceListDialog;
import de.huxhorn.lilith.swing.preferences.GenericSortedListModel;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.swing.preferences.Source;
import de.huxhorn.lilith.swing.preferences.SourceCellRenderer;
import de.huxhorn.sulky.swing.Windows;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceListsPanel
extends JPanel {
    final Logger logger = LoggerFactory.getLogger(SourceListsPanel.class);
    private JList sourceListList;
    private GenericSortedListModel<String> sourceListListModel;
    private EditSourceListAction editSourceListAction;
    private RemoveSourceListAction removeSourceListAction;
    private PreferencesDialog preferencesDialog;
    private EditSourceListDialog editSourceListDialog;
    private GenericSortedListModel<Source> listModel;

    public SourceListsPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.createUI();
    }

    private void createUI() {
        this.editSourceListDialog = new EditSourceListDialog(this.preferencesDialog);
        this.setLayout(new BorderLayout());
        this.sourceListListModel = new GenericSortedListModel();
        this.sourceListList = new JList<String>(this.sourceListListModel);
        this.sourceListList.addMouseListener(new SourceListMouseListener());
        JScrollPane sourceListScrollPane = new JScrollPane(this.sourceListList);
        sourceListScrollPane.setBorder(new TitledBorder("Source Lists"));
        SourceCellRenderer sourceCellRenderer = new SourceCellRenderer();
        this.listModel = new GenericSortedListModel();
        JList<Source> listList = new JList<Source>(this.listModel);
        listList.setEnabled(false);
        listList.setCellRenderer(sourceCellRenderer);
        this.sourceListList.addListSelectionListener(new SourceListListSelectionListener());
        JScrollPane listScrollPane = new JScrollPane(listList);
        listScrollPane.setBorder(new TitledBorder("List content"));
        JPanel listsPanel = new JPanel(new GridLayout(1, 2));
        listsPanel.add(sourceListScrollPane);
        listsPanel.add(listScrollPane);
        JToolBar sourceListsToolbar = new JToolBar();
        sourceListsToolbar.setFloatable(false);
        AddSourceListAction addSourceListAction = new AddSourceListAction();
        this.editSourceListAction = new EditSourceListAction();
        this.removeSourceListAction = new RemoveSourceListAction();
        JButton addSourceListButton = new JButton(addSourceListAction);
        JButton editSourceListButton = new JButton(this.editSourceListAction);
        JButton removeSourceListButton = new JButton(this.removeSourceListAction);
        sourceListsToolbar.add(addSourceListButton);
        sourceListsToolbar.add(editSourceListButton);
        sourceListsToolbar.add(removeSourceListButton);
        ListSelectionModel sourceListSelectionModel = this.sourceListList.getSelectionModel();
        sourceListSelectionModel.setSelectionMode(0);
        sourceListSelectionModel.addListSelectionListener(new SourceListSelectionListener());
        this.add((Component)sourceListsToolbar, "North");
        this.add((Component)listsPanel, "Center");
    }

    public void initUI() {
        this.updateSourceLists();
        this.updateListContents();
        this.updateActions();
    }

    private void updateSourceLists() {
        this.sourceListListModel.setData(new ArrayList<String>(this.preferencesDialog.getSourceListNames()));
    }

    private void updateListContents() {
        String selected = (String)this.sourceListList.getSelectedValue();
        List<Source> list = null;
        if (selected != null) {
            list = this.preferencesDialog.getSourceList(selected);
        }
        if (list == null) {
            list = new ArrayList<Source>();
        }
        this.listModel.setData(list);
    }

    private void updateActions() {
        int selectedIndex = this.sourceListList.getSelectedIndex();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("selectedIndex={}", selectedIndex);
        }
        this.editSourceListAction.setEnabled(selectedIndex != -1);
        this.removeSourceListAction.setEnabled(selectedIndex != -1);
    }

    public void editSourceList(String sourceListName, boolean add) {
        this.editSourceListDialog.setSourceListName(sourceListName);
        List<Source> data = this.preferencesDialog.getSourceList(sourceListName);
        data = data == null ? new ArrayList<Source>() : new ArrayList<Source>(data);
        this.editSourceListDialog.setAdding(add);
        this.editSourceListDialog.setSources(data);
        Windows.showWindow((Window)this.editSourceListDialog, (Window)this.preferencesDialog, (boolean)true);
        if (!this.editSourceListDialog.isCanceled()) {
            String newSourceListName = this.editSourceListDialog.getSourcListeName();
            List<Source> sources = this.editSourceListDialog.getSources();
            this.preferencesDialog.setSourceList(sourceListName, newSourceListName, sources);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After show of editSourceListDialog...");
        }
    }

    private class SourceListListSelectionListener
    implements ListSelectionListener {
        private SourceListListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SourceListsPanel.this.updateListContents();
            SourceListsPanel.this.updateActions();
        }
    }

    private class SourceListMouseListener
    implements MouseListener {
        private final Logger logger = LoggerFactory.getLogger(SourceListMouseListener.class);

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2 && evt.getButton() == 1) {
                Point p = evt.getPoint();
                int row = SourceListsPanel.this.sourceListList.locationToIndex(p);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Source-List-Index: {}", row);
                }
                if (row >= 0) {
                    String sourceListName = (String)SourceListsPanel.this.sourceListListModel.getElementAt(row);
                    if (sourceListName == null) {
                        sourceListName = "";
                    }
                    SourceListsPanel.this.editSourceList(sourceListName, false);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("After show...");
                    }
                }
            } else if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        private void showPopup(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class RemoveSourceListAction
    extends AbstractAction {
        public RemoveSourceListAction() {
            super("Remove");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-remove.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Remove the selected Source List.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (SourceListsPanel.this.logger.isDebugEnabled()) {
                SourceListsPanel.this.logger.debug("Remove");
            }
            if ((row = SourceListsPanel.this.sourceListList.getSelectedIndex()) >= 0) {
                String sourceListName = (String)SourceListsPanel.this.sourceListListModel.getElementAt(row);
                SourceListsPanel.this.preferencesDialog.removeSourceList(sourceListName);
            }
        }
    }

    private class EditSourceListAction
    extends AbstractAction {
        public EditSourceListAction() {
            super("Edit");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-add.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Edit a Source List.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (SourceListsPanel.this.logger.isDebugEnabled()) {
                SourceListsPanel.this.logger.debug("Edit");
            }
            if ((row = SourceListsPanel.this.sourceListList.getSelectedIndex()) >= 0) {
                String sourceListName = (String)SourceListsPanel.this.sourceListListModel.getElementAt(row);
                SourceListsPanel.this.editSourceList(sourceListName, false);
            }
        }
    }

    private class AddSourceListAction
    extends AbstractAction {
        public AddSourceListAction() {
            super("Add");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-add.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Add a new Source List.");
        }

        public void actionPerformed(ActionEvent e) {
            if (SourceListsPanel.this.logger.isDebugEnabled()) {
                SourceListsPanel.this.logger.debug("Add");
            }
            String sourceListName = "";
            SourceListsPanel.this.editSourceList(sourceListName, true);
        }
    }

    private class SourceListSelectionListener
    implements ListSelectionListener {
        private SourceListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SourceListsPanel.this.updateActions();
        }
    }
}

