/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ProgressGlassPane;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.sulky.buffers.DisposeOperation;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewContainer<T extends Serializable>
extends JPanel
implements DisposeOperation {
    public static final String SELECTED_EVENT_PROPERTY_NAME = "selectedEvent";
    private static final ImageIcon globalFrameImageIcon;
    private static final Map<LoggingViewState, ImageIcon> frameIconImages;
    private final List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();
    private EventWrapperViewPanel<T> defaultView;
    private MainFrame mainFrame;

    public ViewContainer(MainFrame mainFrame, EventSource<T> eventSource) {
        this.mainFrame = mainFrame;
        this.defaultView = this.createViewPanel(eventSource);
        this.defaultView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName())) {
                    ViewContainer.this.updateContainerIcon();
                }
            }
        });
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    protected abstract EventWrapperViewPanel<T> createViewPanel(EventSource<T> var1);

    public abstract EventWrapperViewPanel<T> getViewAt(int var1);

    public abstract EventWrapperViewPanel<T> getSelectedView();

    public abstract void addView(EventWrapperViewPanel<T> var1);

    public abstract void removeView(EventWrapperViewPanel<T> var1, boolean var2);

    public abstract void showDefaultView();

    public abstract Class getWrappedClass();

    public EventWrapperViewPanel<T> getDefaultView() {
        return this.defaultView;
    }

    public ViewWindow resolveViewWindow() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof ViewWindow); parent = parent.getParent()) {
        }
        return (ViewWindow)((Object)parent);
    }

    private void updateContainerIcon() {
        ViewWindow window = this.resolveViewWindow();
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)((Object)window);
            this.updateFrameIcon(frame);
        } else if (window instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)((Object)window);
            this.updateInternalFrameIcon(frame);
        }
    }

    private static ImageIcon resolveIconForState(LoggingViewState state) {
        ImageIcon result = globalFrameImageIcon;
        if (state != null) {
            result = frameIconImages.get((Object)state);
        }
        return result;
    }

    private void updateFrameIcon(JFrame frame) {
        ImageIcon frameImageIcon = ViewContainer.resolveIconForState(this.defaultView.getState());
        if (frameImageIcon != null) {
            frame.setIconImage(frameImageIcon.getImage());
        }
    }

    private void updateInternalFrameIcon(JInternalFrame iframe) {
        ImageIcon frameImageIcon = ViewContainer.resolveIconForState(this.defaultView.getState());
        if (frameImageIcon != null) {
            iframe.setFrameIcon(frameImageIcon);
            iframe.repaint();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateContainerIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        boolean changed = false;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (!this.changeListeners.contains(listener)) {
                this.changeListeners.add(listener);
                changed = true;
            }
        }
        if (changed) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        boolean changed = false;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (this.changeListeners.contains(listener)) {
                this.changeListeners.remove(listener);
                changed = true;
            }
        }
        if (changed) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange() {
        ArrayList<ChangeListener> clone;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            clone = new ArrayList<ChangeListener>(this.changeListeners);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : clone) {
            listener.stateChanged(event);
        }
    }

    public abstract void closeCurrentFilter();

    public abstract void closeOtherFilters();

    public abstract void closeAllFilters();

    public abstract int getViewCount();

    public abstract void setViewIndex(int var1);

    public abstract int getViewIndex();

    public abstract void hideSearchPanel();

    public abstract void showSearchPanel(Future<Integer> var1);

    public abstract boolean isSearching();

    public abstract void cancelSearching();

    public abstract ProgressGlassPane getProgressPanel();

    public abstract EventWrapper<T> getSelectedEvent();

    public abstract void updateViews();

    public abstract void scrollToBottom();

    static {
        URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/categories/applications-internet.png");
        globalFrameImageIcon = url != null ? new ImageIcon(url) : null;
        frameIconImages = new HashMap<LoggingViewState, ImageIcon>();
        url = EventWrapperViewPanel.class.getResource("/tango/16x16/status/network-receive.png");
        if (url != null) {
            frameIconImages.put(LoggingViewState.ACTIVE, new ImageIcon(url));
        }
        if ((url = EventWrapperViewPanel.class.getResource("/tango/16x16/status/network-offline.png")) != null) {
            frameIconImages.put(LoggingViewState.INACTIVE, new ImageIcon(url));
        }
    }
}

