/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.rrd4j.core.ArcState;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdDb;
import org.rrd4j.inspector.InspectorModel;
import org.rrd4j.inspector.Util;

class ArchiveTableModel
extends AbstractTableModel {
    private static final Object[] DESCRIPTIONS = new Object[]{"consolidation", "xff", "steps", "rows", "accum. value", "NaN steps", "start", "end"};
    private static final String[] COLUMN_NAMES = new String[]{"description", "value"};
    private File file;
    private Object[] values;
    private int dsIndex = -1;
    private int arcIndex = -1;

    ArchiveTableModel() {
    }

    public int getRowCount() {
        return DESCRIPTIONS.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return DESCRIPTIONS[n];
        }
        if (n2 == 1) {
            if (this.values != null) {
                return this.values[n];
            }
            return "--";
        }
        return null;
    }

    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    void setFile(File file) {
        this.file = file;
        this.setIndex(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIndex(int n, int n2) {
        if (this.dsIndex != n || this.arcIndex != n2) {
            this.dsIndex = n;
            this.arcIndex = n2;
            this.values = null;
            if (this.dsIndex >= 0 && this.arcIndex >= 0) {
                try {
                    RrdDb rrdDb = new RrdDb(this.file.getAbsolutePath(), true);
                    try {
                        Archive archive = rrdDb.getArchive(this.arcIndex);
                        ArcState arcState = archive.getArcState(this.dsIndex);
                        this.values = new Object[]{archive.getConsolFun(), "" + archive.getXff(), "" + archive.getSteps(), "" + archive.getRows(), InspectorModel.formatDouble(arcState.getAccumValue()), "" + arcState.getNanSteps(), "" + archive.getStartTime() + " [" + new Date(archive.getStartTime() * 1000L) + "]", "" + archive.getEndTime() + " [" + new Date(archive.getEndTime() * 1000L) + "]"};
                    }
                    finally {
                        rrdDb.close();
                    }
                }
                catch (Exception exception) {
                    Util.error(null, exception);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

