/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.preferences.FiltersPanel;
import de.huxhorn.lilith.swing.preferences.GeneralPanel;
import de.huxhorn.lilith.swing.preferences.SoundsPanel;
import de.huxhorn.lilith.swing.preferences.Source;
import de.huxhorn.lilith.swing.preferences.SourceFilteringPanel;
import de.huxhorn.lilith.swing.preferences.SourceListsPanel;
import de.huxhorn.lilith.swing.preferences.SourcesPanel;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.swing.KeyStrokes;
import groovy.ui.Console;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(PreferencesDialog.class);
    private ApplicationPreferences applicationPreferences;
    private MainFrame mainFrame;
    private JTabbedPane tabbedPane;
    private GeneralPanel generalPanel;
    private SoundsPanel soundsPanel;
    private SourcesPanel sourcesPanel;
    private SourceListsPanel sourceListsPanel;
    private FiltersPanel filtersPanel;
    private Map<String, String> sourceNames;
    private Map<String, Set<String>> sourceLists;
    private SourceFilteringPanel sourceFilteringPanel;
    private String blackListName;
    private String whiteListName;
    private ApplicationPreferences.SourceFiltering sourceFiltering;
    private Map<String, Condition> conditions;

    public PreferencesDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, "Preferences");
        this.mainFrame = mainFrame;
        this.applicationPreferences = mainFrame.getApplicationPreferences();
        this.createUI();
    }

    public ApplicationPreferences getApplicationPreferences() {
        return this.applicationPreferences;
    }

    private void createUI() {
        this.generalPanel = new GeneralPanel(this);
        this.soundsPanel = new SoundsPanel(this);
        this.sourcesPanel = new SourcesPanel(this);
        this.sourceListsPanel = new SourceListsPanel(this);
        this.sourceFilteringPanel = new SourceFilteringPanel(this);
        this.filtersPanel = new FiltersPanel(this);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(400, 300));
        this.tabbedPane.add("General", this.generalPanel);
        this.tabbedPane.add("Sounds", this.soundsPanel);
        this.tabbedPane.add("Sources", this.sourcesPanel);
        this.tabbedPane.add("Source Lists", this.sourceListsPanel);
        this.tabbedPane.add("Source Filtering", this.sourceFilteringPanel);
        this.tabbedPane.add("Event Filters", this.filtersPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(new OkAction()));
        buttonPanel.add(new JButton(new ApplyAction()));
        buttonPanel.add(new JButton(new ResetAction()));
        CancelAction cancelAction = new CancelAction();
        buttonPanel.add(new JButton(cancelAction));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.tabbedPane, "Center");
        contentPane.add((Component)buttonPanel, "South");
        KeyStrokes.registerCommand((JComponent)this.tabbedPane, (Action)cancelAction, (String)"CANCEL_ACTION");
        KeyStrokes.registerCommand((JComponent)buttonPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
    }

    private void initUI() {
        this.generalPanel.initUI();
        this.soundsPanel.initUI();
        this.sourceNames = this.applicationPreferences.getSourceNames();
        this.sourceNames = this.sourceNames == null ? new HashMap<String, String>() : new HashMap<String, String>(this.sourceNames);
        this.conditions = this.applicationPreferences.getConditions();
        this.sourceLists = this.applicationPreferences.getSourceLists();
        this.sourcesPanel.initUI();
        this.sourceListsPanel.initUI();
        this.sourceFilteringPanel.initUI();
        this.filtersPanel.initUI();
    }

    public Map<String, String> getSourceNames() {
        return this.sourceNames;
    }

    public void setSourceNames(Map<String, String> sourceNames) {
        this.sourceNames = sourceNames;
        this.sourcesPanel.initUI();
        this.sourceListsPanel.initUI();
    }

    public void setSourceName(String oldIdentifier, String newIdentifier, String sourceName) {
        if (this.sourceNames.containsKey(oldIdentifier)) {
            this.sourceNames.remove(oldIdentifier);
        }
        this.sourceNames.put(newIdentifier, sourceName);
        this.sourcesPanel.initUI();
        this.sourceListsPanel.initUI();
    }

    public void setSourceList(String oldName, String newName, List<Source> sourceList) {
        if (this.sourceLists.containsKey(oldName)) {
            this.sourceLists.remove(oldName);
        }
        HashSet<String> newList = new HashSet<String>();
        for (Source s : sourceList) {
            newList.add(s.getIdentifier());
        }
        this.sourceLists.put(newName, newList);
        this.sourceListsPanel.initUI();
        this.sourceFilteringPanel.initUI();
    }

    public List<Source> getSourceList(String name) {
        Set<String> srcList = this.sourceLists.get(name);
        if (srcList != null) {
            ArrayList<Source> result = new ArrayList<Source>();
            for (String current : srcList) {
                Source s = new Source();
                s.setIdentifier(current);
                s.setName(this.getSourceName(current));
                result.add(s);
            }
            Collections.sort(result);
            return result;
        }
        return new ArrayList<Source>();
    }

    private String getSourceName(String identifier) {
        String result = this.sourceNames.get(identifier);
        if (result == null) {
            result = identifier;
        }
        return result;
    }

    private void saveSettings() {
        this.generalPanel.saveSettings();
        this.soundsPanel.saveSettings();
        this.applicationPreferences.setSourceNames(this.sourceNames);
        this.applicationPreferences.setSourceLists(this.sourceLists);
        this.applicationPreferences.setBlackListName(this.blackListName);
        this.applicationPreferences.setWhiteListName(this.whiteListName);
        this.applicationPreferences.setSourceFiltering(this.sourceFiltering);
        if (this.conditions != null) {
            this.applicationPreferences.setConditions(this.conditions);
        }
    }

    private void resetSettings() {
        this.applicationPreferences.reset();
        this.initUI();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            if (visible) {
                this.initUI();
            }
            super.setVisible(visible);
        }
    }

    public List<String> getSourceListNames() {
        return new ArrayList<String>(this.sourceLists.keySet());
    }

    public void removeSourceList(String sourceListName) {
        if (this.sourceLists.containsKey(sourceListName)) {
            this.sourceLists.remove(sourceListName);
            this.sourceListsPanel.initUI();
            this.sourceFilteringPanel.initUI();
        }
    }

    public String getBlackListName() {
        if (this.blackListName == null) {
            this.blackListName = this.applicationPreferences.getBlackListName();
        }
        return this.blackListName;
    }

    public String getWhiteListName() {
        if (this.whiteListName == null) {
            this.whiteListName = this.applicationPreferences.getWhiteListName();
        }
        return this.whiteListName;
    }

    public ApplicationPreferences.SourceFiltering getSourceFiltering() {
        if (this.sourceFiltering == null) {
            this.sourceFiltering = this.applicationPreferences.getSourceFiltering();
        }
        return this.sourceFiltering;
    }

    public void setSourceFiltering(ApplicationPreferences.SourceFiltering sourceFiltering) {
        this.sourceFiltering = sourceFiltering;
    }

    public void setBlackListName(String blackListName) {
        this.blackListName = blackListName;
    }

    public void setWhiteListName(String whiteListName) {
        this.whiteListName = whiteListName;
    }

    public Map<String, Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Map<String, Condition> conditions) {
        this.conditions = conditions;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("this.conditions={}", this.conditions);
        }
    }

    public void editSourceName(String sourceIdentifier) {
        this.tabbedPane.setSelectedComponent(this.sourcesPanel);
        if (!this.isVisible()) {
            this.mainFrame.showPreferencesDialog();
        }
        this.sourcesPanel.editSourceName(sourceIdentifier);
    }

    public void editDetailsFormatter() {
        String text;
        File messageViewGroovyFile;
        Console console;
        block6: {
            console = new Console();
            File messageViewRoot = this.applicationPreferences.getDetailsViewRoot();
            messageViewGroovyFile = new File(messageViewRoot, "detailsView.groovy");
            EventWrapper eventWrapper = new EventWrapper(new SourceIdentifier("identifier", "secondaryIdentifier"), 17L, (Serializable)new LoggingEvent());
            console.setVariable("eventWrapper", (Object)eventWrapper);
            console.setCurrentFileChooserDir(messageViewRoot);
            text = "";
            if (messageViewGroovyFile.isFile()) {
                try {
                    FileInputStream is = new FileInputStream(messageViewGroovyFile);
                    List lines = IOUtils.readLines((InputStream)is, (String)"UTF-8");
                    boolean isFirst = true;
                    StringBuffer textBuffer = new StringBuffer();
                    for (Object o : lines) {
                        String s = (String)o;
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            textBuffer.append("\n");
                        }
                        textBuffer.append(s);
                    }
                    text = textBuffer.toString();
                }
                catch (IOException e) {
                    if (!this.logger.isInfoEnabled()) break block6;
                    this.logger.info("Exception while reading '" + messageViewGroovyFile.getAbsolutePath() + "'.", (Throwable)e);
                }
            }
        }
        console.run();
        console.setScriptFile((Object)messageViewGroovyFile);
        JTextPane inputArea = console.getInputArea();
        inputArea.setText(text);
        console.setDirty(false);
        inputArea.setCaretPosition(0);
        inputArea.requestFocusInWindow();
    }

    public void editCondition(Condition condition) {
        this.tabbedPane.setSelectedComponent(this.filtersPanel);
        if (!this.isVisible()) {
            this.mainFrame.showPreferencesDialog();
        }
        this.filtersPanel.editCondition(condition);
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ESCAPE");
            if (PreferencesDialog.this.logger.isDebugEnabled()) {
                PreferencesDialog.this.logger.debug("accelerator: {}", (Object)accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.setVisible(false);
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super("Reset");
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.resetSettings();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            super("Apply");
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.saveSettings();
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.saveSettings();
            PreferencesDialog.this.setVisible(false);
        }
    }
}

