/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplashScreen
extends JWindow {
    private final Logger logger = LoggerFactory.getLogger(SplashScreen.class);
    private JLabel statusLabel;

    public SplashScreen(String applicationTitle) {
        this.initUI(applicationTitle);
    }

    private void initUI(String applicationTitle) {
        JPanel contentPane;
        block4: {
            contentPane = new JPanel(true);
            contentPane.setLayout(new BorderLayout());
            URL url = SplashScreen.class.getResource("/splash/splash.jpg");
            if (url != null) {
                try {
                    BufferedImage image = ImageIO.read(url);
                    if (image != null) {
                        ImagePanel imagePanel = new ImagePanel(image);
                        contentPane.add((Component)imagePanel, "Center");
                    }
                }
                catch (IOException ex) {
                    if (!this.logger.isWarnEnabled()) break block4;
                    this.logger.warn("Exception while loading image!", (Throwable)ex);
                }
            }
        }
        this.statusLabel = new JLabel();
        JLabel titleLabel = new JLabel(applicationTitle);
        contentPane.add((Component)titleLabel, "North");
        contentPane.add((Component)this.statusLabel, "South");
        this.statusLabel.setText("Initializing...");
        this.setContentPane(contentPane);
    }

    public void setStatusText(String statusText) {
        this.statusLabel.setText(statusText);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Status: {}", (Object)statusText);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.toFront();
        this.repaint();
    }

    private class ImagePanel
    extends JComponent {
        private BufferedImage image;

        public ImagePanel(BufferedImage image) {
            this.image = image;
            this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        }

        public void paint(Graphics g) {
            if (SplashScreen.this.logger.isInfoEnabled()) {
                SplashScreen.this.logger.info("paint");
            }
            g.drawImage(this.image, 0, 0, this);
        }

        public void update(Graphics g) {
            if (SplashScreen.this.logger.isInfoEnabled()) {
                SplashScreen.this.logger.info("update");
            }
            this.paint(g);
        }

        protected void paintComponent(Graphics g) {
            this.paint(g);
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
            if (SplashScreen.this.logger.isInfoEnabled()) {
                SplashScreen.this.logger.info("imageUpdate");
            }
            this.repaint();
            return (infoflags & 0xA0) == 0;
        }
    }
}

