/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.Lilith;
import de.huxhorn.sulky.conditions.Condition;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPreferences {
    private static final String DETAILS_VIEW_ROOT_FOLDER = "detailsView";
    public static final String DETAILS_VIEW_CSS_FILENAME = "detailsView.css";
    public static final String DETAILS_VIEW_GROOVY_FILENAME = "detailsView.groovy";
    private static final String CONDITIONS_XML_FILENAME = "conditions.xml";
    private static final String CONDITIONS_PROPERTY = "conditions";
    private File detailsViewRoot;
    private static final Preferences PREFERENCES = Preferences.userNodeForPackage(ApplicationPreferences.class);
    public static final String CLEANING_LOGS_ON_EXIT_PROPERTY = "cleaningLogsOnExit";
    public static final String SHOWING_IDENTIFIER_PROPERTY = "showingIdentifier";
    public static final String SHOWING_FULL_CALLSTACK_PROPERTY = "showingFullCallstack";
    public static final String CHECKING_FOR_UPDATE_PROPERTY = "checkingForUpdate";
    public static final String SOURCE_FILTERING_PROPERTY = "sourceFiltering";
    public static final String SOUND_LOCATIONS_PROPERTY = "soundLocations";
    public static final String MUTE_PROPERTY = "mute";
    public static final String USING_INTERNAL_FRAMES_PROPERTY = "usingInternalFrames";
    public static final String SCROLLING_TO_BOTTOM_PROPERTY = "scrollingToBottom";
    public static final String SOURCE_NAMES_PROPERTY = "sourceNames";
    public static final String APPLICATION_PATH_PROPERTY = "applicationPath";
    public static final String AUTO_OPENING_PROPERTY = "autoOpening";
    public static final String AUTO_CLOSING_PROPERTY = "autoClosing";
    public static final String IMAGE_PATH_PROPERTY = "imagePath";
    public static final String SOUND_PATH_PROPERTY = "soundPath";
    public static final String AUTO_FOCUSING_WINDOW_PROPERTY = "autoFocusingWindow";
    public static final String SOURCE_LISTS_PROPERTY = "sourceLists";
    public static final String BLACK_LIST_NAME_PROPERTY = "blackListName";
    public static final String WHITE_LIST_NAME_PROPERTY = "whiteListName";
    public static final String SOURCE_NAMES_XML_FILENAME = "SourceNames.xml";
    public static final String SOURCE_LISTS_XML_FILENAME = "SourceLists.xml";
    public static final String SOURCE_NAMES_PROPERTIES_FILENAME = "SourceNames.properties";
    public static final String SOUND_LOCATIONS_XML_FILENAME = "SoundLocations.xml";
    public static final String SOUND_LOCATIONS_PROPERTIES_FILENAME = "SoundLocations.properties";
    public static final String PREVIOUS_APPLICATION_PATH_FILENAME = ".previous.application.path";
    private static final String OLD_LICENSED_PREFERENCES_KEY = "licensed";
    private static final String LICENSED_PREFERENCES_KEY = "licensedVersion";
    public static final String DEFAULT_APPLICATION_PATH;
    private static final Map<String, String> DEFAULT_SOURCE_NAMES;
    private static final Map<String, String> DEFAULT_SOUND_LOCATIONS;
    private final Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
    private File startupApplicationPath;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private URL detailsViewRootUrl;
    private Map<String, String> sourceNames;
    private long lastSourceNamesModified = -1L;
    private long lastConditionsModified = -1L;
    private Map<String, String> soundLocations;
    private long lastSoundLocationsModified;
    private Map<String, Set<String>> sourceLists;
    private long lastSourceListsModified;
    private SourceFiltering sourceFiltering;
    private Set<String> blackList;
    private Set<String> whiteList;
    private Map<String, Condition> conditions;

    public ApplicationPreferences() {
        this.startupApplicationPath = this.getApplicationPath();
    }

    public void setSourceFiltering(SourceFiltering sourceFiltering) {
        SourceFiltering oldValue = this.getSourceFiltering();
        PREFERENCES.put(SOURCE_FILTERING_PROPERTY, sourceFiltering.toString());
        this.sourceFiltering = sourceFiltering;
        this.propertyChangeSupport.firePropertyChange(SOURCE_FILTERING_PROPERTY, (Object)oldValue, (Object)sourceFiltering);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SourceFiltering set to {}.", (Object)this.sourceFiltering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSourceLists() {
        File appPath = this.getStartupApplicationPath();
        File sourceListsFile = new File(appPath, SOURCE_LISTS_XML_FILENAME);
        if (sourceListsFile.isFile()) {
            long lastModified = sourceListsFile.lastModified();
            if (this.sourceLists != null && this.lastSourceListsModified >= lastModified) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Won't reload source lists.");
                }
                return;
            }
            XMLDecoder d = null;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(sourceListsFile)));
                this.sourceLists = (Map)d.readObject();
                this.lastSourceListsModified = lastModified;
            }
            catch (FileNotFoundException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while loading source lists from sourceListsFile '" + sourceListsFile.getAbsolutePath() + "'!", (Throwable)ex);
                }
                this.sourceLists = new HashMap<String, Set<String>>();
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        } else if (this.sourceLists == null) {
            this.sourceLists = new HashMap<String, Set<String>>();
        }
    }

    public Map<String, Set<String>> getSourceLists() {
        this.initSourceLists();
        return new HashMap<String, Set<String>>(this.sourceLists);
    }

    public void setSourceLists(Map<String, Set<String>> sourceLists) {
        Map<String, Set<String>> oldValue = this.getSourceLists();
        this.writeSourceLists(sourceLists);
        Map<String, Set<String>> newValue = this.getSourceLists();
        this.blackList = null;
        this.whiteList = null;
        this.propertyChangeSupport.firePropertyChange(SOURCE_LISTS_PROPERTY, oldValue, newValue);
    }

    public SourceFiltering getSourceFiltering() {
        if (this.sourceFiltering != null) {
            return this.sourceFiltering;
        }
        String sf = PREFERENCES.get(SOURCE_FILTERING_PROPERTY, "NONE");
        try {
            this.sourceFiltering = SourceFiltering.valueOf(sf);
        }
        catch (IllegalArgumentException e) {
            this.sourceFiltering = SourceFiltering.NONE;
        }
        return this.sourceFiltering;
    }

    private void initDetailsViewRoot() {
        this.detailsViewRoot = new File(this.startupApplicationPath, DETAILS_VIEW_ROOT_FOLDER);
        this.detailsViewRoot.mkdirs();
        try {
            this.detailsViewRootUrl = this.detailsViewRoot.toURI().toURL();
        }
        catch (MalformedURLException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while creating detailsViewRootUrl for '{}'!", (Object)this.detailsViewRoot.getAbsolutePath());
            }
            this.detailsViewRootUrl = null;
        }
        String resourcePath = "/detailsView/detailsView.css";
        String historyBasePath = "/detailsView/history/detailsView.css/";
        File detailsViewCssFile = new File(this.detailsViewRoot, DETAILS_VIEW_CSS_FILENAME);
        this.initIfNecessary(detailsViewCssFile, resourcePath, historyBasePath);
        resourcePath = "/detailsView/detailsView.groovy";
        historyBasePath = "/detailsView/history/detailsView.groovy/";
        File detailsViewGroovyFile = new File(this.detailsViewRoot, DETAILS_VIEW_GROOVY_FILENAME);
        this.initIfNecessary(detailsViewGroovyFile, resourcePath, historyBasePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNecessary(File file, String resourcePath, String historyBasePath) {
        if (file.isFile()) {
            byte[] available = null;
            try {
                FileInputStream availableFile = new FileInputStream(file);
                available = ApplicationPreferences.getMD5(availableFile);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            byte[] current = ApplicationPreferences.getMD5(this.getClass().getResourceAsStream(resourcePath));
            if (Arrays.equals(available, current)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("The current version of {} is also the latest version.", (Object)file.getAbsolutePath());
                }
                return;
            }
            boolean delete = false;
            if (available != null) {
                URL historyUrl = this.getClass().getResource(historyBasePath + "history.txt");
                if (historyUrl != null) {
                    ArrayList<String> historyList = new ArrayList<String>();
                    BufferedReader reader = null;
                    try {
                        String currentLine;
                        reader = new BufferedReader(new InputStreamReader(historyUrl.openStream()));
                        while ((currentLine = reader.readLine()) != null) {
                            historyList.add(currentLine);
                        }
                    }
                    catch (IOException e) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Exception while reading history data!", (Throwable)e);
                        }
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    for (String currentLine : historyList) {
                        InputStream is = this.getClass().getResourceAsStream(historyBasePath + currentLine + ".md5");
                        DataInputStream dis = new DataInputStream(is);
                        byte[] checksum = new byte[16];
                        try {
                            dis.readFully(checksum);
                            if (!Arrays.equals(available, checksum)) continue;
                            if (this.logger.isInfoEnabled()) {
                                this.logger.info("Found old version of {}: {}", (Object)file.getAbsolutePath(), (Object)currentLine);
                            }
                            delete = true;
                            break;
                        }
                        catch (IOException e) {
                            if (!this.logger.isWarnEnabled()) continue;
                            this.logger.warn("Exception while reading checksum of " + currentLine + "!", (Throwable)e);
                        }
                        finally {
                            try {
                                dis.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            } else {
                delete = true;
            }
            if (delete) {
                if (file.delete()) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Deleted {}. ", (Object)file.getAbsolutePath());
                    }
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Tried to delete {} but couldn't!", (Object)file.getAbsolutePath());
                }
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info("Won't update {} because it was changed manually.", (Object)file.getAbsolutePath());
            }
        }
        if (!file.isFile()) {
            InputStream is = this.getClass().getResourceAsStream(resourcePath);
            if (is == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Couldn't find resource {}!", (Object)resourcePath);
                }
                return;
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(file);
                IOUtils.copy((InputStream)is, (OutputStream)os);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Initialized file at '{}'.", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while initializing " + file.getAbsolutePath() + "!", (Throwable)e);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
    }

    public File getDetailsViewRoot() {
        if (this.detailsViewRoot != null) {
            return this.detailsViewRoot;
        }
        this.initDetailsViewRoot();
        return this.detailsViewRoot;
    }

    public URL getDetailsViewRootUrl() {
        if (this.detailsViewRootUrl != null) {
            return this.detailsViewRootUrl;
        }
        this.initDetailsViewRoot();
        return this.detailsViewRootUrl;
    }

    public boolean isValidSource(String source) {
        if (source == null) {
            return false;
        }
        SourceFiltering filtering = this.getSourceFiltering();
        switch (filtering) {
            case BLACKLIST: {
                return !this.isBlackListed(source);
            }
            case WHITELIST: {
                return this.isWhiteListed(source);
            }
        }
        return true;
    }

    public boolean isBlackListed(String source) {
        if (this.blackList == null) {
            String listName = this.getBlackListName();
            this.initSourceLists();
            this.blackList = this.sourceLists.get(listName);
            if (this.blackList == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Couldn't find blacklist '{}'!", (Object)listName);
                }
                this.setSourceFiltering(SourceFiltering.NONE);
                this.setBlackListName("");
                return true;
            }
        }
        return this.blackList.contains(source);
    }

    public void setBlackListName(String name) {
        String oldValue = this.getBlackListName();
        PREFERENCES.put(BLACK_LIST_NAME_PROPERTY, name);
        String newValue = this.getBlackListName();
        this.propertyChangeSupport.firePropertyChange(BLACK_LIST_NAME_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("BlackListName set to {}.", (Object)newValue);
        }
    }

    public String getBlackListName() {
        return PREFERENCES.get(BLACK_LIST_NAME_PROPERTY, "");
    }

    public boolean isWhiteListed(String source) {
        if (this.whiteList == null) {
            String listName = this.getWhiteListName();
            this.initSourceLists();
            this.whiteList = this.sourceLists.get(listName);
            if (this.whiteList == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Couldn't find whitelist '{}'!", (Object)listName);
                }
                this.setSourceFiltering(SourceFiltering.NONE);
                this.setWhiteListName("");
                return true;
            }
        }
        return this.whiteList.contains(source);
    }

    public void setWhiteListName(String name) {
        String oldValue = this.getWhiteListName();
        PREFERENCES.put(WHITE_LIST_NAME_PROPERTY, name);
        String newValue = this.getWhiteListName();
        this.propertyChangeSupport.firePropertyChange(WHITE_LIST_NAME_PROPERTY, oldValue, newValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("WhiteListName set to {}.", (Object)newValue);
        }
    }

    public String getWhiteListName() {
        return PREFERENCES.get(WHITE_LIST_NAME_PROPERTY, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConditions() {
        File appPath = this.getStartupApplicationPath();
        File conditionsFile = new File(appPath, CONDITIONS_XML_FILENAME);
        if (conditionsFile.isFile()) {
            long lastModified = conditionsFile.lastModified();
            if (this.conditions != null && this.lastConditionsModified >= lastModified) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Won't reload conditions.");
                }
                return;
            }
            XMLDecoder d = null;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(conditionsFile)));
                this.conditions = (Map)d.readObject();
                this.lastConditionsModified = lastModified;
            }
            catch (FileNotFoundException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while loading conditions from file '" + conditionsFile.getAbsolutePath() + "'!", (Throwable)ex);
                }
                this.conditions = new HashMap<String, Condition>();
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        } else if (this.conditions == null) {
            this.conditions = new HashMap<String, Condition>();
        }
    }

    public Map<String, Condition> getConditions() {
        this.initConditions();
        return new HashMap<String, Condition>(this.conditions);
    }

    public void setConditions(Map<String, Condition> conditions) {
        Map<String, Condition> oldValue = this.getConditions();
        this.writeConditions(conditions);
        Map<String, Condition> newValue = this.getConditions();
        this.propertyChangeSupport.firePropertyChange(CONDITIONS_PROPERTY, oldValue, newValue);
    }

    public void setAutoOpening(boolean autoOpening) {
        Boolean oldValue = this.isAutoOpening();
        PREFERENCES.putBoolean(AUTO_OPENING_PROPERTY, autoOpening);
        Boolean newValue = this.isAutoOpening();
        this.propertyChangeSupport.firePropertyChange(AUTO_OPENING_PROPERTY, oldValue, newValue);
    }

    public boolean isAutoOpening() {
        return PREFERENCES.getBoolean(AUTO_OPENING_PROPERTY, true);
    }

    public void setShowingIdentifier(boolean showingIdentifierWithName) {
        Boolean oldValue = this.isShowingIdentifier();
        PREFERENCES.putBoolean(SHOWING_IDENTIFIER_PROPERTY, showingIdentifierWithName);
        Boolean newValue = this.isShowingIdentifier();
        this.propertyChangeSupport.firePropertyChange(SHOWING_IDENTIFIER_PROPERTY, oldValue, newValue);
    }

    public boolean isShowingIdentifier() {
        return PREFERENCES.getBoolean(SHOWING_IDENTIFIER_PROPERTY, true);
    }

    public void setShowingFullCallstack(boolean showingFullCallstack) {
        Boolean oldValue = this.isShowingFullCallstack();
        PREFERENCES.putBoolean(SHOWING_FULL_CALLSTACK_PROPERTY, showingFullCallstack);
        Boolean newValue = this.isShowingFullCallstack();
        this.propertyChangeSupport.firePropertyChange(SHOWING_FULL_CALLSTACK_PROPERTY, oldValue, newValue);
    }

    public boolean isShowingFullCallstack() {
        return PREFERENCES.getBoolean(SHOWING_FULL_CALLSTACK_PROPERTY, false);
    }

    public void setCleaningLogsOnExit(boolean cleaningLogsOnExit) {
        Boolean oldValue = this.isCleaningLogsOnExit();
        PREFERENCES.putBoolean(CLEANING_LOGS_ON_EXIT_PROPERTY, cleaningLogsOnExit);
        Boolean newValue = this.isCleaningLogsOnExit();
        this.propertyChangeSupport.firePropertyChange(CLEANING_LOGS_ON_EXIT_PROPERTY, oldValue, newValue);
    }

    public boolean isCleaningLogsOnExit() {
        return PREFERENCES.getBoolean(CLEANING_LOGS_ON_EXIT_PROPERTY, false);
    }

    public void setCheckingForUpdate(boolean checkingForUpdate) {
        Boolean oldValue = this.isCheckingForUpdate();
        PREFERENCES.putBoolean(CHECKING_FOR_UPDATE_PROPERTY, checkingForUpdate);
        Boolean newValue = this.isCheckingForUpdate();
        this.propertyChangeSupport.firePropertyChange(CHECKING_FOR_UPDATE_PROPERTY, oldValue, newValue);
    }

    public boolean isCheckingForUpdate() {
        return PREFERENCES.getBoolean(CHECKING_FOR_UPDATE_PROPERTY, true);
    }

    public void setAutoClosing(boolean autoClosing) {
        Boolean oldValue = this.isAutoClosing();
        PREFERENCES.putBoolean(AUTO_CLOSING_PROPERTY, autoClosing);
        Boolean newValue = this.isAutoClosing();
        this.propertyChangeSupport.firePropertyChange(AUTO_CLOSING_PROPERTY, oldValue, newValue);
    }

    public boolean isAutoClosing() {
        return PREFERENCES.getBoolean(AUTO_CLOSING_PROPERTY, false);
    }

    public File getImagePath() {
        String userHome = System.getProperty("user.home");
        String imagePath = PREFERENCES.get(IMAGE_PATH_PROPERTY, userHome);
        File result = new File(imagePath);
        if (!result.isDirectory()) {
            result = new File(userHome);
        }
        return result;
    }

    public void setImagePath(File imagePath) {
        if (!imagePath.isDirectory()) {
            throw new IllegalArgumentException("'" + imagePath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getImagePath();
        PREFERENCES.put(IMAGE_PATH_PROPERTY, imagePath.getAbsolutePath());
        File newValue = this.getImagePath();
        this.propertyChangeSupport.firePropertyChange(IMAGE_PATH_PROPERTY, oldValue, newValue);
    }

    public File getSoundPath() {
        String userHome = System.getProperty("user.home");
        String soundPath = PREFERENCES.get(SOUND_PATH_PROPERTY, userHome);
        File result = new File(soundPath);
        if (!result.isDirectory()) {
            result = new File(userHome);
        }
        return result;
    }

    public void setSoundPath(File soundPath) {
        if (!soundPath.isDirectory()) {
            throw new IllegalArgumentException("'" + soundPath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getSoundPath();
        PREFERENCES.put(SOUND_PATH_PROPERTY, soundPath.getAbsolutePath());
        File newValue = this.getSoundPath();
        this.propertyChangeSupport.firePropertyChange(SOUND_PATH_PROPERTY, oldValue, newValue);
    }

    public void setMute(boolean mute) {
        Boolean oldValue = this.isMute();
        PREFERENCES.putBoolean(MUTE_PROPERTY, mute);
        Boolean newValue = this.isMute();
        this.propertyChangeSupport.firePropertyChange(MUTE_PROPERTY, oldValue, newValue);
    }

    public boolean isMute() {
        return PREFERENCES.getBoolean(MUTE_PROPERTY, false);
    }

    public void setLicensed(boolean licensed) {
        Boolean oldValue = this.isLicensed();
        if (licensed) {
            PREFERENCES.put(LICENSED_PREFERENCES_KEY, Lilith.APP_VERSION);
        } else {
            PREFERENCES.remove(LICENSED_PREFERENCES_KEY);
        }
        Boolean newValue = this.isLicensed();
        this.propertyChangeSupport.firePropertyChange(LICENSED_PREFERENCES_KEY, oldValue, newValue);
    }

    public boolean isLicensed() {
        return Lilith.APP_VERSION.equals(PREFERENCES.get(LICENSED_PREFERENCES_KEY, null));
    }

    public void setApplicationPath(File applicationPath) {
        applicationPath.mkdirs();
        if (!applicationPath.isDirectory()) {
            throw new IllegalArgumentException("'" + applicationPath.getAbsolutePath() + "' is not a directory!");
        }
        File oldValue = this.getStartupApplicationPath();
        PREFERENCES.put(APPLICATION_PATH_PROPERTY, applicationPath.getAbsolutePath());
        File newValue = this.getApplicationPath();
        this.propertyChangeSupport.firePropertyChange(APPLICATION_PATH_PROPERTY, oldValue, newValue);
    }

    public File getApplicationPath() {
        String appPath = PREFERENCES.get(APPLICATION_PATH_PROPERTY, DEFAULT_APPLICATION_PATH);
        File result = new File(appPath);
        result.mkdirs();
        return result;
    }

    public File getStartupApplicationPath() {
        return this.startupApplicationPath;
    }

    public void setUsingInternalFrames(boolean usingInternalFrames) {
        Boolean oldValue = this.isUsingInternalFrames();
        PREFERENCES.putBoolean(USING_INTERNAL_FRAMES_PROPERTY, usingInternalFrames);
        Boolean newValue = this.isUsingInternalFrames();
        this.propertyChangeSupport.firePropertyChange(USING_INTERNAL_FRAMES_PROPERTY, oldValue, newValue);
    }

    public boolean isUsingInternalFrames() {
        return PREFERENCES.getBoolean(USING_INTERNAL_FRAMES_PROPERTY, true);
    }

    public void setAutoFocusingWindow(boolean autoFocusingWindow) {
        Boolean oldValue = this.isAutoFocusingWindow();
        PREFERENCES.putBoolean(AUTO_FOCUSING_WINDOW_PROPERTY, autoFocusingWindow);
        Boolean newValue = this.isAutoFocusingWindow();
        this.propertyChangeSupport.firePropertyChange(AUTO_FOCUSING_WINDOW_PROPERTY, oldValue, newValue);
    }

    public boolean isAutoFocusingWindow() {
        return PREFERENCES.getBoolean(AUTO_FOCUSING_WINDOW_PROPERTY, false);
    }

    public void setSourceNames(Map<String, String> sourceNames) {
        Map<String, String> oldValue = this.getSourceNames();
        this.writeSourceNames(sourceNames);
        Map<String, String> newValue = this.getSourceNames();
        this.propertyChangeSupport.firePropertyChange(SOURCE_NAMES_PROPERTY, oldValue, newValue);
    }

    public Map<String, String> getSourceNames() {
        File appPath = this.getStartupApplicationPath();
        File sourceNamesFile = new File(appPath, SOURCE_NAMES_XML_FILENAME);
        if (sourceNamesFile.isFile() && this.loadSourceNamesXml(sourceNamesFile)) {
            return new HashMap<String, String>(this.sourceNames);
        }
        sourceNamesFile = new File(appPath, SOURCE_NAMES_PROPERTIES_FILENAME);
        if (sourceNamesFile.isFile() && this.loadSourceNamesProperties(sourceNamesFile)) {
            return new HashMap<String, String>(this.sourceNames);
        }
        return new HashMap<String, String>(DEFAULT_SOURCE_NAMES);
    }

    public Map<String, String> getSoundLocations() {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, SOUND_LOCATIONS_XML_FILENAME);
        if (file.isFile() && this.loadSoundLocationsXml(file)) {
            return new HashMap<String, String>(this.soundLocations);
        }
        file = new File(appPath, SOUND_LOCATIONS_PROPERTIES_FILENAME);
        if (file.isFile() && this.loadSoundLocationsProperties(file)) {
            return new HashMap<String, String>(this.soundLocations);
        }
        return new HashMap<String, String>(DEFAULT_SOUND_LOCATIONS);
    }

    public void setSoundLocations(Map<String, String> soundLocations) {
        Map<String, String> oldValue = this.getSoundLocations();
        this.writeSoundLocations(soundLocations);
        Map<String, String> newValue = this.getSoundLocations();
        this.propertyChangeSupport.firePropertyChange(SOUND_LOCATIONS_PROPERTY, oldValue, newValue);
    }

    public void resetSoundLocations() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initializing preferences with default sound locations.");
        }
        this.setSoundLocations(DEFAULT_SOUND_LOCATIONS);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void reset() {
        block2: {
            Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
            boolean licensed = this.isLicensed();
            try {
                PREFERENCES.clear();
                this.resetSoundLocations();
                this.setLicensed(licensed);
                this.setApplicationPath(new File(DEFAULT_APPLICATION_PATH));
            }
            catch (BackingStoreException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Exception while clearing preferences!");
            }
        }
    }

    public void setScrollingToBottom(boolean scrollingToBottom) {
        Boolean oldValue = this.isScrollingToBottom();
        PREFERENCES.putBoolean(SCROLLING_TO_BOTTOM_PROPERTY, scrollingToBottom);
        Boolean newValue = this.isScrollingToBottom();
        this.propertyChangeSupport.firePropertyChange(SCROLLING_TO_BOTTOM_PROPERTY, oldValue, newValue);
    }

    public boolean isScrollingToBottom() {
        return PREFERENCES.getBoolean(SCROLLING_TO_BOTTOM_PROPERTY, true);
    }

    private boolean loadSoundLocationsProperties(File sourceNamesFile) {
        long lastModified = sourceNamesFile.lastModified();
        if (this.soundLocations != null && this.lastSoundLocationsModified >= lastModified) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Won't reload sound locations.");
            }
            return true;
        }
        Map<String, String> props = this.loadProperties(sourceNamesFile);
        if (props != null) {
            this.lastSoundLocationsModified = lastModified;
            this.soundLocations = props;
            return true;
        }
        return false;
    }

    private boolean loadSoundLocationsXml(File file) {
        long lastModified = file.lastModified();
        if (this.soundLocations != null && this.lastSoundLocationsModified >= lastModified) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Won't reload sound locations.");
            }
            return true;
        }
        Map<String, String> props = this.loadPropertiesXml(file);
        if (props != null) {
            this.lastSoundLocationsModified = lastModified;
            this.soundLocations = props;
            return true;
        }
        return false;
    }

    private boolean writeSoundLocations(Map<String, String> sourceNames) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, SOUND_LOCATIONS_XML_FILENAME);
        return this.writePropertiesXml(file, sourceNames, "Sound locations");
    }

    private boolean loadSourceNamesXml(File file) {
        long lastModified = file.lastModified();
        if (this.sourceNames != null && this.lastSourceNamesModified >= lastModified) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Won't reload source names.");
            }
            return true;
        }
        Map<String, String> props = this.loadPropertiesXml(file);
        if (props != null) {
            this.lastSourceNamesModified = lastModified;
            this.sourceNames = props;
            return true;
        }
        return false;
    }

    private boolean loadSourceNamesProperties(File sourceNamesFile) {
        long lastModified = sourceNamesFile.lastModified();
        if (this.sourceNames != null && this.lastSourceNamesModified >= lastModified) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Won't reload source names.");
            }
            return true;
        }
        Map<String, String> props = this.loadProperties(sourceNamesFile);
        if (props != null) {
            this.lastSourceNamesModified = lastModified;
            this.sourceNames = props;
            return true;
        }
        return false;
    }

    private boolean writeSourceNames(Map<String, String> sourceNames) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, SOURCE_NAMES_XML_FILENAME);
        return this.writePropertiesXml(file, sourceNames, "Source names");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeSourceLists(Map<String, Set<String>> sourceLists) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, SOURCE_LISTS_XML_FILENAME);
        XMLEncoder e = null;
        FileNotFoundException error = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            e = new XMLEncoder(bos);
            e.writeObject(sourceLists);
        }
        catch (FileNotFoundException ex) {
            error = ex;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing source lists!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeConditions(Map<String, Condition> conditions) {
        File appPath = this.getStartupApplicationPath();
        File file = new File(appPath, CONDITIONS_XML_FILENAME);
        XMLEncoder e = null;
        FileNotFoundException error = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            e = new XMLEncoder(bos);
            e.writeObject(conditions);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Wrote conditions {}.", conditions);
            }
        }
        catch (FileNotFoundException ex) {
            error = ex;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing source lists!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> loadPropertiesXml(File file) {
        HashMap<String, String> hashMap;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Properties props = new Properties();
            props.loadFromXML(is);
            HashMap<String, String> result = new HashMap<String, String>();
            for (Object keyObj : props.keySet()) {
                String key = (String)keyObj;
                String value = (String)props.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
            hashMap = result;
        }
        catch (IOException e) {
            block5: {
                try {
                    if (!this.logger.isWarnEnabled()) break block5;
                    this.logger.warn("Couldn't load properties from '" + file.getAbsolutePath() + "'!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return null;
        }
        IOUtils.closeQuietly((InputStream)is);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writePropertiesXml(File file, Map<String, String> sourceNames, String comment) {
        IOException error;
        block10: {
            Properties output = new Properties();
            for (Map.Entry<String, String> entry : sourceNames.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                output.put(key, value);
            }
            BufferedOutputStream os = null;
            error = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                output.storeToXML((OutputStream)os, comment, "UTF-8");
                IOUtils.closeQuietly((OutputStream)os);
            }
            catch (FileNotFoundException e) {
                error = e;
            }
            catch (IOException e2) {
                error = e2;
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(os);
            }
        }
        if (error != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while writing source names!", (Throwable)error);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> loadProperties(File file) {
        HashMap<String, String> hashMap;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Properties props = new Properties();
            props.load(is);
            HashMap<String, String> result = new HashMap<String, String>();
            for (Object keyObj : props.keySet()) {
                String key = (String)keyObj;
                String value = (String)props.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
            hashMap = result;
        }
        catch (IOException e) {
            block5: {
                try {
                    if (!this.logger.isWarnEnabled()) break block5;
                    this.logger.warn("Couldn't load properties from '" + file.getAbsolutePath() + "'!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return null;
        }
        IOUtils.closeQuietly((InputStream)is);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getMD5(InputStream input) {
        if (input == null) {
            return null;
        }
        try {
            int read22;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            while ((read22 = input.read(buffer)) >= 0) {
                messageDigest.update(buffer, 0, read22);
            }
            byte[] read22 = messageDigest.digest();
            return read22;
        }
        catch (Throwable t) {
            Logger logger = LoggerFactory.getLogger(ApplicationPreferences.class);
            if (logger.isWarnEnabled()) {
                logger.warn("Exception while calculating checksum!", t);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {}
        }
        return null;
    }

    static {
        PREFERENCES.remove(OLD_LICENSED_PREFERENCES_KEY);
        String userHome = System.getProperty("user.home");
        File defaultAppPath = new File(userHome, ".lilith");
        DEFAULT_APPLICATION_PATH = defaultAppPath.getAbsolutePath();
        HashMap<String, String> defaultSoundLocations = new HashMap<String, String>();
        defaultSoundLocations.put("sourceAdded", "/events/SourceAdded.mp3");
        defaultSoundLocations.put("sourceRemoved", "/events/SourceRemoved.mp3");
        defaultSoundLocations.put("errorEventAlarm", "/events/ErrorEventAlarm.mp3");
        DEFAULT_SOUND_LOCATIONS = Collections.unmodifiableMap(defaultSoundLocations);
        HashMap<String, String> defaultSourceNames = new HashMap<String, String>();
        defaultSourceNames.put("127.0.0.1", "Localhost");
        DEFAULT_SOURCE_NAMES = Collections.unmodifiableMap(defaultSourceNames);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceFiltering {
        NONE,
        BLACKLIST,
        WHITELIST;

    }
}

