/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.filters;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.sulky.conditions.Condition;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class MessageContainsCondition
implements Condition {
    private static final long serialVersionUID = 6162454733163822936L;
    private String searchString;
    private boolean ignoringCase;
    private transient String actualSearchString;

    public MessageContainsCondition() {
        this(null, false);
    }

    public MessageContainsCondition(String searchString, boolean ignoringCase) {
        this.setIgnoringCase(ignoringCase);
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        this.actualSearchString = this.ignoringCase && searchString != null ? searchString.toLowerCase() : searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setIgnoringCase(boolean ignoringCase) {
        if (this.ignoringCase != ignoringCase) {
            this.ignoringCase = ignoringCase;
            this.setSearchString(this.searchString);
        }
    }

    public boolean isIgnoringCase() {
        return this.ignoringCase;
    }

    public boolean isTrue(Object value) {
        if (this.actualSearchString == null) {
            return false;
        }
        if (value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            Serializable eventObj = wrapper.getEvent();
            if (this.actualSearchString.length() == 0) {
                return true;
            }
            if (eventObj instanceof LoggingEvent) {
                LoggingEvent event = (LoggingEvent)eventObj;
                String message = event.getMessage();
                if (message == null) {
                    return false;
                }
                if (this.ignoringCase) {
                    message = message.toLowerCase();
                }
                return message.contains(this.actualSearchString);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageContainsCondition that = (MessageContainsCondition)o;
        if (this.ignoringCase != that.ignoringCase) {
            return false;
        }
        return !(this.searchString == null ? that.searchString != null : !this.searchString.equals(that.searchString));
    }

    public int hashCode() {
        int result = this.searchString != null ? this.searchString.hashCode() : 0;
        result = 29 * result + (this.ignoringCase ? 1 : 0);
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setSearchString(this.searchString);
    }

    public MessageContainsCondition clone() throws CloneNotSupportedException {
        return (MessageContainsCondition)super.clone();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("message.");
        if (this.ignoringCase) {
            result.append("containsIgnoreCase(");
        } else {
            result.append("contains(");
        }
        if (this.searchString != null) {
            result.append("\"");
            result.append(this.searchString);
            result.append("\"");
        } else {
            result.append("null");
        }
        result.append(")");
        return result.toString();
    }
}

