/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.consumers;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.EventConsumer;
import de.huxhorn.sulky.io.TimeoutOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketEventConsumer<T extends Serializable>
implements EventConsumer<T>,
Runnable {
    final Logger logger = LoggerFactory.getLogger(SocketEventConsumer.class);
    private static final int DEFAULT_RECONNECTION_DELAY = 60000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_WRITE_TIMEOUT = 1500;
    private ObjectOutputStream output = null;
    private long failTime = 0L;
    private String host;
    private int port;
    private int connectionTimeout = 10000;
    private int writeTimeout = 1500;
    private long reconnectionDelay = 60000L;

    public SocketEventConsumer(String host, int port) {
        this();
        this.host = host;
        this.port = port;
    }

    public SocketEventConsumer() {
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setReconnectionDelay(long reconnectionDelay) {
        this.reconnectionDelay = reconnectionDelay;
    }

    public void consume(List<EventWrapper<T>> events) {
        if (events == null) {
            return;
        }
        int eventCount = events.size();
        if (eventCount == 0) {
            return;
        }
        if (this.output == null) {
            int count = events.size();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Dropping {} events.", (Object)count);
            }
        } else {
            try {
                for (EventWrapper<T> eventWrapper : events) {
                    Serializable event = eventWrapper.getEvent();
                    if (event != null) {
                        this.output.writeObject(eventWrapper.getEvent());
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Wrote event.");
                        continue;
                    }
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Detected end of stream for source {}.", (Object)eventWrapper.getSourceIdentifier());
                }
                this.output.flush();
            }
            catch (IOException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Exception while writing event.", (Throwable)e);
                }
                IOUtils.closeQuietly((OutputStream)this.output);
                this.output = null;
                this.failTime = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            if (this.output == null) {
                this.initObjectOutputStream();
            }
            try {
                Thread.sleep(this.reconnectionDelay);
            }
            catch (InterruptedException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Interrupted...", (Throwable)e);
                }
                return;
            }
        }
    }

    private void initObjectOutputStream() {
        if (this.output != null) {
            return;
        }
        long current = System.currentTimeMillis();
        if (current - this.failTime >= this.reconnectionDelay) {
            InetSocketAddress address = new InetSocketAddress(this.host, this.port);
            try {
                Socket socket = new Socket();
                socket.connect(address, this.connectionTimeout);
                socket.setSoTimeout(this.connectionTimeout);
                this.output = new ObjectOutputStream(new BufferedOutputStream((OutputStream)new TimeoutOutputStream(socket.getOutputStream(), this.writeTimeout)));
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Created connection to {}.", (Object)address);
                }
            }
            catch (IOException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Exception while creating connection to " + address + ".", (Throwable)e);
                }
                IOUtils.closeQuietly((OutputStream)this.output);
                this.output = null;
                this.failTime = current;
            }
        }
    }
}

