/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.logback;

import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ThrowableInformation;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.MessageFormatter;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackLoggingAdapter {
    private static final String CLASSNAME_MESSAGE_SEPARATOR = ": ";
    private static final String COMMON_FRAMES_OMITTED = " common frames omitted";
    private static final String NATIVE_METHOD = "Native Method";
    private static final String UNKNOWN_SOURCE = "Unknown Source";
    private static final Field throwableField;

    public LoggingEvent convert(ch.qos.logback.classic.spi.LoggingEvent event) {
        if (event == null) {
            return null;
        }
        LoggingEvent result = new LoggingEvent();
        String messagePattern = event.getMessage();
        result.setMessagePattern(messagePattern);
        Object[] originalArguments = event.getArgumentArray();
        MessageFormatter.ArgumentResult argumentResult = MessageFormatter.evaluateArguments((String)messagePattern, (Object[])originalArguments);
        boolean throwableInitialized = false;
        if (argumentResult != null) {
            result.setArguments(argumentResult.getArguments());
            Throwable t = argumentResult.getThrowable();
            if (t != null) {
                result.setThrowable(this.initFromThrowableRecursive(t));
                throwableInitialized = true;
            }
        }
        if (!throwableInitialized) {
            this.initThrowable(event, result);
        }
        this.initCallStack(event, result);
        result.setLevel(LoggingEvent.Level.valueOf((String)event.getLevel().toString()));
        result.setLogger(event.getLoggerRemoteView().getName());
        this.initMarker(event, result);
        result.setMdc(event.getMDCPropertyMap());
        result.setThreadName(event.getThreadName());
        result.setTimeStamp(new Date(event.getTimeStamp()));
        return result;
    }

    private void initThrowable(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        ThrowableInformation ti = src.getThrowableInformation();
        if (ti == null) {
            return;
        }
        if (!this.initFromThrowable(ti, dst)) {
            this.initFromThrowableStrRep(ti, dst);
        }
    }

    Throwable getThrowable(ThrowableInformation ti) {
        if (throwableField == null) {
            return null;
        }
        try {
            return (Throwable)throwableField.get(ti);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    private boolean initFromThrowable(ThrowableInformation ti, LoggingEvent dst) {
        Throwable t = this.getThrowable(ti);
        if (t == null) {
            return false;
        }
        dst.setThrowable(this.initFromThrowableRecursive(t));
        return true;
    }

    private ThrowableInfo initFromThrowableRecursive(Throwable t) {
        if (t == null) {
            return null;
        }
        ThrowableInfo info = new ThrowableInfo();
        info.setName(t.getClass().getName());
        info.setMessage(t.getMessage());
        info.setStackTrace(this.convert(t.getStackTrace()));
        info.setCause(this.initFromThrowableRecursive(t.getCause()));
        return info;
    }

    private ExtendedStackTraceElement[] convert(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return null;
        }
        ExtendedStackTraceElement[] result = new ExtendedStackTraceElement[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            result[i] = new ExtendedStackTraceElement(stackTrace[i]);
        }
        return result;
    }

    void initFromThrowableStrRep(ThrowableInformation ti, LoggingEvent dst) {
        String[] throwStrRep = ti.getThrowableStrRep();
        if (throwStrRep == null) {
            return;
        }
        dst.setThrowable(this.initFromThrowableStrRepRecursive(throwStrRep, 0));
    }

    ThrowableInfo initFromThrowableStrRepRecursive(String[] throwStrRep, int index) {
        if (index >= throwStrRep.length) {
            return null;
        }
        String current = throwStrRep[index];
        if (current.startsWith("Caused by: ")) {
            current = current.substring("Caused by: ".length());
        }
        int colonIdx = current.indexOf(CLASSNAME_MESSAGE_SEPARATOR);
        ThrowableInfo result = new ThrowableInfo();
        if (colonIdx == -1) {
            result.setName(current);
        } else {
            result.setName(current.substring(0, colonIdx));
            result.setMessage(current.substring(colonIdx + CLASSNAME_MESSAGE_SEPARATOR.length()));
        }
        ArrayList<StackTraceElement> stackElements = new ArrayList<StackTraceElement>();
        for (int i = ++index; i < throwStrRep.length; ++i) {
            current = throwStrRep[i];
            if (current.startsWith("Caused by: ")) {
                result.setStackTrace(this.convert(stackElements.toArray(new StackTraceElement[stackElements.size()])));
                stackElements.clear();
                result.setCause(this.initFromThrowableStrRepRecursive(throwStrRep, i));
                break;
            }
            if (current.endsWith(COMMON_FRAMES_OMITTED)) continue;
            stackElements.add(LogbackLoggingAdapter.parseStackTraceElement(current));
        }
        return result;
    }

    public static StackTraceElement parseStackTraceElement(String current) {
        int idx = current.lastIndexOf("(");
        String classAndMethod = current.substring(0, idx);
        String source = current.substring(idx + 1, current.length() - 1);
        idx = classAndMethod.lastIndexOf(".");
        String clazz = classAndMethod.substring(0, idx);
        String method = classAndMethod.substring(idx + 1, classAndMethod.length());
        idx = source.lastIndexOf(":");
        String file = null;
        int lineNumber = -1;
        if (idx != -1) {
            file = source.substring(0, idx);
            lineNumber = Integer.parseInt(source.substring(idx + 1, source.length()));
        } else if (source.equals(NATIVE_METHOD)) {
            lineNumber = -2;
        } else if (!source.equals(UNKNOWN_SOURCE)) {
            file = source;
        }
        return new StackTraceElement(clazz, method, file, lineNumber);
    }

    private void initCallStack(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        CallerData[] cd = src.getCallerData();
        if (cd == null) {
            return;
        }
        StackTraceElement[] callStack = new StackTraceElement[cd.length];
        for (int i = 0; i < cd.length; ++i) {
            CallerData current = cd[i];
            int lineNumber = current.getLineNumber();
            if (current.isNativeMethod()) {
                lineNumber = -2;
            }
            callStack[i] = new StackTraceElement(current.getClassName(), current.getMethodName(), current.getFileName(), lineNumber);
        }
        dst.setCallStack(this.convert(callStack));
    }

    private void initMarker(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        org.slf4j.Marker origMarker = src.getMarker();
        if (origMarker == null) {
            return;
        }
        HashMap<String, Marker> markers = new HashMap<String, Marker>();
        dst.setMarker(this.initMarkerRecursive(origMarker, markers));
    }

    private Marker initMarkerRecursive(org.slf4j.Marker origMarker, Map<String, Marker> markers) {
        if (origMarker == null) {
            return null;
        }
        String name = origMarker.getName();
        if (markers.containsKey(name)) {
            return markers.get(name);
        }
        Marker newMarker = new Marker(name);
        markers.put(name, newMarker);
        if (origMarker.hasChildren()) {
            for (org.slf4j.Marker current : origMarker) {
                newMarker.add(this.initMarkerRecursive(current, markers));
            }
        }
        return newMarker;
    }

    static {
        Field field = null;
        try {
            Class<?> clazz = Class.forName("ch.qos.logback.classic.spi.ThrowableInformation");
            field = clazz.getDeclaredField("throwable");
            field.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        throwableField = field;
    }
}

