/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.buffers.FilterJob;
import de.huxhorn.sulky.buffers.ResetOperation;
import de.huxhorn.sulky.conditions.Condition;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buffers {
    private Buffers() {
    }

    public static <E> void filter(Buffer<E> buffer, Condition condition, AppendOperation<E> toAppendTo) {
        for (Object element : buffer) {
            if (!condition.isTrue(element)) continue;
            toAppendTo.add(element);
        }
    }

    public static <E> void filter(Buffer<E> buffer, FilterJob<E> filterJob) {
        Buffers.filter(buffer, filterJob.getCondition(), filterJob.getAppendOperation());
    }

    public static <E> void filter(Buffer<E> buffer, Collection<FilterJob<E>> filterJobs) {
        for (Object element : buffer) {
            for (FilterJob<E> job : filterJobs) {
                if (!job.getCondition().isTrue(element)) continue;
                job.getAppendOperation().add(element);
            }
        }
    }

    public static void dispose(Buffer<?> buffer) {
        if (buffer instanceof DisposeOperation) {
            DisposeOperation op = (DisposeOperation)((Object)buffer);
            op.dispose();
        }
    }

    public static void reset(Buffer<?> buffer) {
        if (buffer instanceof ResetOperation) {
            ResetOperation op = (ResetOperation)((Object)buffer);
            op.reset();
        }
    }
}

