/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.logback.appender;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.logback.LogbackAccessAdapter;
import de.huxhorn.lilith.logback.appender.MultiplexSocketAppenderBase;
import de.huxhorn.sulky.generics.io.SerializableSerializer;
import de.huxhorn.sulky.generics.io.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessMultiplexSocketAppender
extends MultiplexSocketAppenderBase<ch.qos.logback.access.spi.AccessEvent> {
    public static final int COMRESSED_DEFAULT_PORT = 10010;
    public static final int UNCOMPRESSED_DEFAULT_PORT = 10011;
    private boolean compressing;
    private boolean usingDefaultPort = true;
    private Serializer<AccessEvent> lilithSerializer;

    public AccessMultiplexSocketAppender() {
        this(true);
    }

    public AccessMultiplexSocketAppender(boolean compressing) {
        this.setCompressing(compressing);
    }

    public void setPort(int port) {
        super.setPort(port);
        this.usingDefaultPort = false;
    }

    public void sendLilithEvent(AccessEvent e) {
        byte[] serialized;
        if (this.lilithSerializer != null && (serialized = this.lilithSerializer.serialize((Object)e)) != null) {
            this.sendBytes(serialized);
        }
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
        if (this.usingDefaultPort) {
            if (compressing) {
                this.setPort(10010);
            } else {
                this.setPort(10011);
            }
            this.usingDefaultPort = true;
        }
        this.lilithSerializer = new SerializableSerializer(compressing);
        this.setSerializer(new TransformingSerializer());
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    protected void preProcess(ch.qos.logback.access.spi.AccessEvent e) {
        if (e != null) {
            e.prepareForDeferredProcessing();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformingSerializer
    implements Serializer<ch.qos.logback.access.spi.AccessEvent> {
        LogbackAccessAdapter adapter = new LogbackAccessAdapter();

        private TransformingSerializer() {
        }

        public byte[] serialize(ch.qos.logback.access.spi.AccessEvent logbackEvent) {
            AccessEvent lilithEvent = this.adapter.convert(logbackEvent);
            lilithEvent.setApplicationIdentifier(AccessMultiplexSocketAppender.this.getApplicationIdentifier());
            return AccessMultiplexSocketAppender.this.lilithSerializer.serialize((Object)lilithEvent);
        }
    }
}

