/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ReflectorGenerator
implements Opcodes {
    private List methods;
    private ClassVisitor cv;
    private BytecodeHelper helper = new BytecodeHelper(null);
    private String classInternalName;
    private static List m_names = new ArrayList();

    private static String get_m_name(int i) {
        while (i >= m_names.size()) {
            m_names.add("m" + m_names.size());
        }
        return (String)m_names.get(i);
    }

    public ReflectorGenerator(List methods) {
        this.methods = new ArrayList(methods.size());
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            CachedMethod method = (CachedMethod)it.next();
            if (!method.canBeCalledByReflector()) continue;
            this.methods.add(method);
        }
    }

    public void generate(ClassVisitor cv, String className) {
        this.cv = cv;
        this.classInternalName = BytecodeHelper.getClassInternalName(className);
        cv.visit(47, 33, this.classInternalName, null, "org/codehaus/groovy/runtime/Reflector", null);
        cv.visitField(9, "accessor", "Ljava/lang/Object;", null, null);
        MethodVisitor mvInit = cv.visitMethod(1, "<init>", "()V", null, null);
        mvInit.visitVarInsn(25, 0);
        mvInit.visitMethodInsn(183, "org/codehaus/groovy/runtime/Reflector", "<init>", "()V");
        mvInit.visitInsn(177);
        mvInit.visitMaxs(1, 1);
        MethodVisitor mvClinit = cv.visitMethod(8, "<clinit>", "()V", null, null);
        mvClinit.visitTypeInsn(187, this.classInternalName);
        mvClinit.visitInsn(89);
        mvClinit.visitMethodInsn(183, this.classInternalName, "<init>", "()V");
        mvClinit.visitFieldInsn(179, this.classInternalName, "accessor", "Ljava/lang/Object;");
        mvClinit.visitInsn(177);
        mvClinit.visitMaxs(1, 1);
        this.generateInvokeMethod();
        cv.visitEnd();
    }

    protected void generateInvokeMethod() {
        CachedMethod method;
        int i;
        int methodCount = this.methods.size();
        MethodVisitor mv = this.cv.visitMethod(1, "invoke", "(Lorg/codehaus/groovy/reflection/CachedMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/codehaus/groovy/reflection/CachedMethod", "getMethodIndex", "()I");
        Label defaultLabel = new Label();
        Label[] labels = new Label[methodCount];
        int[] indices = new int[methodCount];
        for (i = 0; i < methodCount; ++i) {
            labels[i] = new Label();
            method = (CachedMethod)this.methods.get(i);
            indices[i] = i + 1;
            method.setMethodIndex(indices[i]);
        }
        mv.visitLookupSwitchInsn(defaultLabel, indices, labels);
        for (i = 0; i < methodCount; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitMethodInsn(183, this.classInternalName, ReflectorGenerator.get_m_name(i), "(Lorg/codehaus/groovy/reflection/CachedMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(176);
        }
        mv.visitLabel(defaultLabel);
        mv.visitMethodInsn(182, this.classInternalName, "noSuchMethod", "(Lorg/codehaus/groovy/reflection/CachedMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(4, 4);
        mv.visitEnd();
        for (i = 0; i < methodCount; ++i) {
            mv = this.cv.visitMethod(2, ReflectorGenerator.get_m_name(i), "(Lorg/codehaus/groovy/reflection/CachedMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            this.helper = new BytecodeHelper(mv);
            method = (CachedMethod)this.methods.get(i);
            this.invokeMethod(method, mv);
            if (method.getReturnType() == Void.TYPE) {
                mv.visitInsn(1);
            }
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    protected void invokeMethod(CachedMethod method, MethodVisitor mv) {
        Class callClass = method.getDeclaringClass().getTheClass();
        boolean useInterface = callClass.isInterface();
        String type = BytecodeHelper.getClassInternalName(callClass.getName());
        String descriptor = BytecodeHelper.getMethodDescriptor(method.getReturnType(), method.getNativeParameterTypes());
        if (method.isStatic()) {
            this.loadParameters(method, 3, mv);
            mv.visitMethodInsn(184, type, method.getName(), descriptor);
        } else {
            mv.visitVarInsn(25, 2);
            this.helper.doCast(callClass);
            this.loadParameters(method, 3, mv);
            mv.visitMethodInsn(useInterface ? 185 : 182, type, method.getName(), descriptor);
        }
        this.helper.box(method.getReturnType());
    }

    protected void loadParameters(CachedMethod method, int argumentIndex, MethodVisitor mv) {
        CachedClass[] parameters = method.getParameterTypes();
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            mv.visitVarInsn(25, argumentIndex);
            this.helper.pushConstant(i);
            mv.visitInsn(50);
            Class type = parameters[i].getTheClass();
            if (type.isPrimitive()) {
                this.helper.unbox(type);
                continue;
            }
            this.helper.doCast(type);
        }
    }
}

