/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class TimeoutOutputStream
extends OutputStream {
    private final OutputStream stream;
    private int timeout;
    private AtomicLong operationStartTime;
    private AtomicBoolean closed;
    private Thread watchdogThread;
    private AtomicBoolean watchdogThreadRunning = new AtomicBoolean(false);

    public TimeoutOutputStream(OutputStream stream, int timeout) {
        if (stream == null) {
            throw new NullPointerException("stream must not be null!");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be a positive value!");
        }
        this.stream = stream;
        this.timeout = timeout;
        this.operationStartTime = new AtomicLong(-1L);
        this.closed = new AtomicBoolean(false);
        TimeoutRunnable timeoutRunnable = new TimeoutRunnable();
        this.watchdogThread = new Thread((Runnable)timeoutRunnable, "TimeoutOutputStream Watchdog-Thread");
        this.watchdogThread.start();
        Thread.yield();
    }

    public void write(byte[] b) throws IOException {
        try {
            this.operationStartTime.set(System.currentTimeMillis());
            this.stream.write(b);
            this.operationStartTime.set(-1L);
        }
        catch (IOException ex) {
            this.internalClose();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.internalClose();
            throw ex;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.operationStartTime.set(System.currentTimeMillis());
            this.stream.write(b, off, len);
            this.operationStartTime.set(-1L);
        }
        catch (IOException ex) {
            this.internalClose();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.internalClose();
            throw ex;
        }
    }

    public void write(int b) throws IOException {
        try {
            this.operationStartTime.set(System.currentTimeMillis());
            this.stream.write(b);
            this.operationStartTime.set(-1L);
        }
        catch (IOException ex) {
            this.internalClose();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.internalClose();
            throw ex;
        }
    }

    public void flush() throws IOException {
        try {
            this.operationStartTime.set(System.currentTimeMillis());
            this.stream.flush();
            this.operationStartTime.set(-1L);
        }
        catch (IOException ex) {
            this.internalClose();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.internalClose();
            throw ex;
        }
    }

    public void close() throws IOException {
        this.internalClose();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalClose() throws IOException {
        if (!this.closed.get()) {
            this.closed.set(true);
            try {
                this.stream.close();
            }
            finally {
                if (this.watchdogThread != null) {
                    this.watchdogThread.interrupt();
                    this.watchdogThread = null;
                }
            }
        }
    }

    boolean isWatchdogThreadRunning() {
        return this.watchdogThreadRunning.get();
    }

    private class TimeoutRunnable
    implements Runnable {
        private TimeoutRunnable() {
        }

        public void run() {
            TimeoutOutputStream.this.watchdogThreadRunning.set(true);
            try {
                while (!TimeoutOutputStream.this.closed.get()) {
                    long start = TimeoutOutputStream.this.operationStartTime.get();
                    if (start >= 0L) {
                        long since = System.currentTimeMillis() - start;
                        if (since > (long)TimeoutOutputStream.this.timeout) {
                            TimeoutOutputStream.this.internalClose();
                            break;
                        }
                        Thread.sleep((long)TimeoutOutputStream.this.timeout - since);
                        continue;
                    }
                    Thread.sleep(TimeoutOutputStream.this.timeout);
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            TimeoutOutputStream.this.watchdogThreadRunning.set(false);
        }
    }
}

