/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.xml;

import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.xml.LoggingEventReader;
import de.huxhorn.sulky.generics.io.Deserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingXmlDeserializer
implements Deserializer<LoggingEvent> {
    private XMLInputFactory inputFactory;
    private LoggingEventReader loggingEventReader;
    private boolean compressing;

    public LoggingXmlDeserializer(boolean compressing) {
        this.compressing = compressing;
        this.inputFactory = XMLInputFactory.newInstance();
        this.loggingEventReader = new LoggingEventReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingEvent deserialize(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            XMLStreamReader reader;
            GZIPInputStream gis;
            if (this.compressing) {
                gis = new GZIPInputStream(in);
                reader = this.inputFactory.createXMLStreamReader(new InputStreamReader((InputStream)gis, "utf-8"));
            } else {
                reader = this.inputFactory.createXMLStreamReader(new InputStreamReader((InputStream)in, "utf-8"));
            }
            gis = this.loggingEventReader.read(reader);
            return gis;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return null;
    }
}

