/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.xml;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.data.logging.xml.LoggingEventSchemaConstants;
import de.huxhorn.lilith.data.logging.xml.StackTraceElementReader;
import de.huxhorn.sulky.stax.DateTimeFormatter;
import de.huxhorn.sulky.stax.GenericStreamReader;
import de.huxhorn.sulky.stax.StaxUtilities;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventReader
implements GenericStreamReader<LoggingEvent>,
LoggingEventSchemaConstants {
    private DateTimeFormatter dateTimeFormatter = new DateTimeFormatter();
    private StackTraceElementReader steReader = new StackTraceElementReader();

    public LoggingEvent read(XMLStreamReader reader) throws XMLStreamException {
        LoggingEvent result = null;
        String rootNamespace = "http://lilith.sf.net/schema/logging/11";
        int type = reader.getEventType();
        if (7 == type) {
            reader.nextTag();
            type = reader.getEventType();
            rootNamespace = null;
        }
        if (1 == type && "LoggingEvent".equals(reader.getLocalName())) {
            result = new LoggingEvent();
            result.setLogger(StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"logger"));
            result.setApplicationIdentifier(StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"applicationId"));
            result.setLevel(LoggingEvent.Level.valueOf((String)StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"level")));
            result.setThreadName(StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"threadName"));
            String timeStamp = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"timeStamp");
            try {
                result.setTimeStamp(this.dateTimeFormatter.parse(timeStamp));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            reader.nextTag();
            result.setMessagePattern(StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"Message"));
            this.readArguments(reader, result);
            this.readThrowable(reader, result);
            result.setMdc(this.readMdc(reader));
            this.readMarker(reader, result);
            this.readCallStack(reader, result);
            reader.require(2, rootNamespace, "LoggingEvent");
        }
        return result;
    }

    private void readCallStack(XMLStreamReader reader, LoggingEvent event) throws XMLStreamException {
        event.setCallStack(this.readStackTraceNode(reader, "CallStack"));
    }

    private ExtendedStackTraceElement[] readStackTraceNode(XMLStreamReader reader, String nodeName) throws XMLStreamException {
        int type = reader.getEventType();
        ArrayList<ExtendedStackTraceElement> ste = new ArrayList<ExtendedStackTraceElement>();
        if (1 == type && nodeName.equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            ExtendedStackTraceElement elem;
            reader.nextTag();
            while ((elem = this.steReader.read(reader)) != null) {
                reader.nextTag();
                ste.add(elem);
            }
            reader.require(2, "http://lilith.sf.net/schema/logging/11", nodeName);
            reader.nextTag();
            return ste.toArray(new ExtendedStackTraceElement[ste.size()]);
        }
        return null;
    }

    private void readMarker(XMLStreamReader reader, LoggingEvent event) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "Marker".equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            HashMap<String, Marker> markers = new HashMap<String, Marker>();
            Marker marker = this.recursiveReadMarker(reader, markers);
            event.setMarker(marker);
        }
    }

    private Marker recursiveReadMarker(XMLStreamReader reader, Map<String, Marker> markers) throws XMLStreamException {
        Marker marker = null;
        int type = reader.getEventType();
        if (1 == type && "Marker".equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            Marker child;
            String name = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"name");
            marker = new Marker(name);
            markers.put(name, marker);
            reader.nextTag();
            while ((child = this.recursiveReadMarker(reader, markers)) != null) {
                markers.put(child.getName(), child);
                marker.add(child);
            }
            reader.require(2, "http://lilith.sf.net/schema/logging/11", "Marker");
            reader.nextTag();
        } else if (1 == type && "MarkerReference".equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            String ref = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"ref");
            marker = markers.get(ref);
            reader.nextTag();
            reader.require(2, "http://lilith.sf.net/schema/logging/11", "MarkerReference");
            reader.nextTag();
        }
        return marker;
    }

    private Map<String, String> readMdc(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "MDC".equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            MdcEntry entry;
            HashMap<String, String> mdc = new HashMap<String, String>();
            reader.nextTag();
            while ((entry = this.readMdcEntry(reader)) != null) {
                mdc.put(entry.key, entry.value);
            }
            reader.require(2, "http://lilith.sf.net/schema/logging/11", "MDC");
            reader.nextTag();
            return mdc;
        }
        return null;
    }

    private MdcEntry readMdcEntry(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "Entry".equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            MdcEntry entry = new MdcEntry();
            entry.key = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"key");
            entry.value = StaxUtilities.readText((XMLStreamReader)reader);
            reader.require(2, "http://lilith.sf.net/schema/logging/11", "Entry");
            reader.nextTag();
            return entry;
        }
        return null;
    }

    private void readThrowable(XMLStreamReader reader, LoggingEvent event) throws XMLStreamException {
        event.setThrowable(this.recursiveReadThrowable(reader, "Throwable"));
    }

    private ThrowableInfo recursiveReadThrowable(XMLStreamReader reader, String nodeName) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && nodeName.equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            ThrowableInfo throwable = new ThrowableInfo();
            String name = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"name");
            throwable.setName(name);
            reader.nextTag();
            throwable.setMessage(StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"Message"));
            throwable.setStackTrace(this.readStackTraceNode(reader, "StackTrace"));
            throwable.setCause(this.recursiveReadThrowable(reader, "Cause"));
            reader.require(2, "http://lilith.sf.net/schema/logging/11", nodeName);
            reader.nextTag();
            return throwable;
        }
        return null;
    }

    private void readArguments(XMLStreamReader reader, LoggingEvent event) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "Arguments".equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            reader.nextTag();
            ArrayList<String> args = new ArrayList<String>();
            while (true) {
                if (2 == (type = reader.getEventType()) && "Arguments".equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) break;
                String arg = this.readArgument(reader);
                args.add(arg);
            }
            reader.nextTag();
            event.setArguments(args.toArray(new String[args.size()]));
        }
    }

    private String readArgument(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "null".equals(reader.getLocalName()) && "http://lilith.sf.net/schema/logging/11".equals(reader.getNamespaceURI())) {
            reader.nextTag();
            reader.require(2, "http://lilith.sf.net/schema/logging/11", "null");
            reader.nextTag();
            return null;
        }
        return StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/logging/11", (String)"Argument");
    }

    private static class MdcEntry {
        public String key;
        public String value;

        private MdcEntry() {
        }
    }
}

